// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.LinearRetrieverConverter))]
public sealed partial class LinearRetriever
{
#if NET7_0_OR_GREATER
	public LinearRetriever()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public LinearRetriever()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<string>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public float? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public string? Name { get; set; }
	public Elastic.Clients.Elasticsearch.ScoreNormalizer? Normalizer { get; set; }
	public string? Query { get; set; }
	public int? RankWindowSize { get; set; }

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.InnerRetriever>? Retrievers { get; set; }
}

public readonly partial struct LinearRetrieverDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.LinearRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LinearRetrieverDescriptor(Elastic.Clients.Elasticsearch.LinearRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LinearRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument>(Elastic.Clients.Elasticsearch.LinearRetriever instance) => new Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Fields(params string[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Normalizer(Elastic.Clients.Elasticsearch.ScoreNormalizer? value)
	{
		Instance.Normalizer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Retrievers(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.InnerRetriever>? value)
	{
		Instance.Retrievers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Retrievers(params Elastic.Clients.Elasticsearch.InnerRetriever[] values)
	{
		Instance.Retrievers = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument> Retrievers(params System.Action<Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.InnerRetriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor<TDocument>.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LinearRetriever Build(System.Action<Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct LinearRetrieverDescriptor
{
	internal Elastic.Clients.Elasticsearch.LinearRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LinearRetrieverDescriptor(Elastic.Clients.Elasticsearch.LinearRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LinearRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor(Elastic.Clients.Elasticsearch.LinearRetriever instance) => new Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Fields(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Fields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Fields(params string[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Normalizer(Elastic.Clients.Elasticsearch.ScoreNormalizer? value)
	{
		Instance.Normalizer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Retrievers(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.InnerRetriever>? value)
	{
		Instance.Retrievers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Retrievers(params Elastic.Clients.Elasticsearch.InnerRetriever[] values)
	{
		Instance.Retrievers = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Retrievers(params System.Action<Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.InnerRetriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retrievers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor Retrievers<T>(params System.Action<Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.InnerRetriever>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.InnerRetrieverDescriptor<T>.Build(action));
		}

		Instance.Retrievers = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LinearRetriever Build(System.Action<Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.LinearRetrieverDescriptor(new Elastic.Clients.Elasticsearch.LinearRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}