// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class LifecycleOperationModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.LifecycleOperationMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberRunning = System.Text.Json.JsonEncodedText.Encode("RUNNING");
	private static readonly System.Text.Json.JsonEncodedText MemberStopped = System.Text.Json.JsonEncodedText.Encode("STOPPED");
	private static readonly System.Text.Json.JsonEncodedText MemberStopping = System.Text.Json.JsonEncodedText.Encode("STOPPING");

	public override Elastic.Clients.Elasticsearch.LifecycleOperationMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberRunning))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Running;
		}

		if (reader.ValueTextEquals(MemberStopped))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopped;
		}

		if (reader.ValueTextEquals(MemberStopping))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopping;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberRunning.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Running;
		}

		if (string.Equals(value, MemberStopped.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopped;
		}

		if (string.Equals(value, MemberStopping.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopping;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LifecycleOperationMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LifecycleOperationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.LifecycleOperationMode.Running:
				writer.WriteStringValue(MemberRunning);
				break;
			case Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopped:
				writer.WriteStringValue(MemberStopped);
				break;
			case Elastic.Clients.Elasticsearch.LifecycleOperationMode.Stopping:
				writer.WriteStringValue(MemberStopping);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LifecycleOperationMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.LifecycleOperationMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LifecycleOperationMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}