// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement.Json;

public sealed partial class LicenseTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBasic = System.Text.Json.JsonEncodedText.Encode("basic");
	private static readonly System.Text.Json.JsonEncodedText MemberDev = System.Text.Json.JsonEncodedText.Encode("dev");
	private static readonly System.Text.Json.JsonEncodedText MemberEnterprise = System.Text.Json.JsonEncodedText.Encode("enterprise");
	private static readonly System.Text.Json.JsonEncodedText MemberGold = System.Text.Json.JsonEncodedText.Encode("gold");
	private static readonly System.Text.Json.JsonEncodedText MemberMissing = System.Text.Json.JsonEncodedText.Encode("missing");
	private static readonly System.Text.Json.JsonEncodedText MemberPlatinum = System.Text.Json.JsonEncodedText.Encode("platinum");
	private static readonly System.Text.Json.JsonEncodedText MemberSilver = System.Text.Json.JsonEncodedText.Encode("silver");
	private static readonly System.Text.Json.JsonEncodedText MemberStandard = System.Text.Json.JsonEncodedText.Encode("standard");
	private static readonly System.Text.Json.JsonEncodedText MemberTrial = System.Text.Json.JsonEncodedText.Encode("trial");

	public override Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBasic))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Basic;
		}

		if (reader.ValueTextEquals(MemberDev))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Dev;
		}

		if (reader.ValueTextEquals(MemberEnterprise))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Enterprise;
		}

		if (reader.ValueTextEquals(MemberGold))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Gold;
		}

		if (reader.ValueTextEquals(MemberMissing))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Missing;
		}

		if (reader.ValueTextEquals(MemberPlatinum))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Platinum;
		}

		if (reader.ValueTextEquals(MemberSilver))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Silver;
		}

		if (reader.ValueTextEquals(MemberStandard))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Standard;
		}

		if (reader.ValueTextEquals(MemberTrial))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Trial;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBasic.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Basic;
		}

		if (string.Equals(value, MemberDev.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Dev;
		}

		if (string.Equals(value, MemberEnterprise.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Enterprise;
		}

		if (string.Equals(value, MemberGold.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Gold;
		}

		if (string.Equals(value, MemberMissing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Missing;
		}

		if (string.Equals(value, MemberPlatinum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Platinum;
		}

		if (string.Equals(value, MemberSilver.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Silver;
		}

		if (string.Equals(value, MemberStandard.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Standard;
		}

		if (string.Equals(value, MemberTrial.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Trial;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Basic:
				writer.WriteStringValue(MemberBasic);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Dev:
				writer.WriteStringValue(MemberDev);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Enterprise:
				writer.WriteStringValue(MemberEnterprise);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Gold:
				writer.WriteStringValue(MemberGold);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Missing:
				writer.WriteStringValue(MemberMissing);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Platinum:
				writer.WriteStringValue(MemberPlatinum);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Silver:
				writer.WriteStringValue(MemberSilver);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Standard:
				writer.WriteStringValue(MemberStandard);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType.Trial:
				writer.WriteStringValue(MemberTrial);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}