// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement.Json;

public sealed partial class LicenseStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberActive = System.Text.Json.JsonEncodedText.Encode("active");
	private static readonly System.Text.Json.JsonEncodedText MemberExpired = System.Text.Json.JsonEncodedText.Encode("expired");
	private static readonly System.Text.Json.JsonEncodedText MemberInvalid = System.Text.Json.JsonEncodedText.Encode("invalid");
	private static readonly System.Text.Json.JsonEncodedText MemberValid = System.Text.Json.JsonEncodedText.Encode("valid");

	public override Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberActive))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Active;
		}

		if (reader.ValueTextEquals(MemberExpired))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Expired;
		}

		if (reader.ValueTextEquals(MemberInvalid))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Invalid;
		}

		if (reader.ValueTextEquals(MemberValid))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Valid;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberActive.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Active;
		}

		if (string.Equals(value, MemberExpired.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Expired;
		}

		if (string.Equals(value, MemberInvalid.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Invalid;
		}

		if (string.Equals(value, MemberValid.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Valid;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Active:
				writer.WriteStringValue(MemberActive);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Expired:
				writer.WriteStringValue(MemberExpired);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Invalid:
				writer.WriteStringValue(MemberInvalid);
				break;
			case Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus.Valid:
				writer.WriteStringValue(MemberValid);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}