// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement.Json;

public sealed partial class LicenseInformationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseInformation>
{
	private static readonly System.Text.Json.JsonEncodedText PropExpiryDate = System.Text.Json.JsonEncodedText.Encode("expiry_date");
	private static readonly System.Text.Json.JsonEncodedText PropExpiryDateInMillis = System.Text.Json.JsonEncodedText.Encode("expiry_date_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropIssueDate = System.Text.Json.JsonEncodedText.Encode("issue_date");
	private static readonly System.Text.Json.JsonEncodedText PropIssueDateInMillis = System.Text.Json.JsonEncodedText.Encode("issue_date_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropIssuedTo = System.Text.Json.JsonEncodedText.Encode("issued_to");
	private static readonly System.Text.Json.JsonEncodedText PropIssuer = System.Text.Json.JsonEncodedText.Encode("issuer");
	private static readonly System.Text.Json.JsonEncodedText PropMaxNodes = System.Text.Json.JsonEncodedText.Encode("max_nodes");
	private static readonly System.Text.Json.JsonEncodedText PropMaxResourceUnits = System.Text.Json.JsonEncodedText.Encode("max_resource_units");
	private static readonly System.Text.Json.JsonEncodedText PropStartDateInMillis = System.Text.Json.JsonEncodedText.Encode("start_date_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropStatus = System.Text.Json.JsonEncodedText.Encode("status");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropUid = System.Text.Json.JsonEncodedText.Encode("uid");

	public override Elastic.Clients.Elasticsearch.LicenseManagement.LicenseInformation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.DateTimeOffset?> propExpiryDate = default;
		LocalJsonValue<System.DateTimeOffset?> propExpiryDateInMillis = default;
		LocalJsonValue<System.DateTimeOffset> propIssueDate = default;
		LocalJsonValue<System.DateTimeOffset> propIssueDateInMillis = default;
		LocalJsonValue<string> propIssuedTo = default;
		LocalJsonValue<string> propIssuer = default;
		LocalJsonValue<long?> propMaxNodes = default;
		LocalJsonValue<int?> propMaxResourceUnits = default;
		LocalJsonValue<System.DateTimeOffset> propStartDateInMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseStatus> propStatus = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType> propType = default;
		LocalJsonValue<string> propUid = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propExpiryDate.TryReadProperty(ref reader, options, PropExpiryDate, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker))))
			{
				continue;
			}

			if (propExpiryDateInMillis.TryReadProperty(ref reader, options, PropExpiryDateInMillis, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propIssueDate.TryReadProperty(ref reader, options, PropIssueDate, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker))))
			{
				continue;
			}

			if (propIssueDateInMillis.TryReadProperty(ref reader, options, PropIssueDateInMillis, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propIssuedTo.TryReadProperty(ref reader, options, PropIssuedTo, null))
			{
				continue;
			}

			if (propIssuer.TryReadProperty(ref reader, options, PropIssuer, null))
			{
				continue;
			}

			if (propMaxNodes.TryReadProperty(ref reader, options, PropMaxNodes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMaxResourceUnits.TryReadProperty(ref reader, options, PropMaxResourceUnits, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propStartDateInMillis.TryReadProperty(ref reader, options, PropStartDateInMillis, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propStatus.TryReadProperty(ref reader, options, PropStatus, null))
			{
				continue;
			}

			if (propType.TryReadProperty(ref reader, options, PropType, null))
			{
				continue;
			}

			if (propUid.TryReadProperty(ref reader, options, PropUid, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.LicenseManagement.LicenseInformation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ExpiryDate = propExpiryDate.Value,
			ExpiryDateInMillis = propExpiryDateInMillis.Value,
			IssueDate = propIssueDate.Value,
			IssueDateInMillis = propIssueDateInMillis.Value,
			IssuedTo = propIssuedTo.Value,
			Issuer = propIssuer.Value,
			MaxNodes = propMaxNodes.Value,
			MaxResourceUnits = propMaxResourceUnits.Value,
			StartDateInMillis = propStartDateInMillis.Value,
			Status = propStatus.Value,
			Type = propType.Value,
			Uid = propUid.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseInformation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropExpiryDate, value.ExpiryDate, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker)));
		writer.WriteProperty(options, PropExpiryDateInMillis, value.ExpiryDateInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropIssueDate, value.IssueDate, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker)));
		writer.WriteProperty(options, PropIssueDateInMillis, value.IssueDateInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropIssuedTo, value.IssuedTo, null, null);
		writer.WriteProperty(options, PropIssuer, value.Issuer, null, null);
		writer.WriteProperty(options, PropMaxNodes, value.MaxNodes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMaxResourceUnits, value.MaxResourceUnits, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropStartDateInMillis, value.StartDateInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropStatus, value.Status, null, null);
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropUid, value.Uid, null, null);
		writer.WriteEndObject();
	}
}