// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.LicenseManagement.Json.LicenseConverter))]
public sealed partial class License
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public License(System.DateTimeOffset expiryDateInMillis, System.DateTimeOffset issueDateInMillis, string issuedTo, string issuer, string signature, Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType type, string uid)
	{
		ExpiryDateInMillis = expiryDateInMillis;
		IssueDateInMillis = issueDateInMillis;
		IssuedTo = issuedTo;
		Issuer = issuer;
		Signature = signature;
		Type = type;
		Uid = uid;
	}
#if NET7_0_OR_GREATER
	public License()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public License()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal License(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset ExpiryDateInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset IssueDateInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string IssuedTo { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Issuer { get; set; }
	public long? MaxNodes { get; set; }
	public long? MaxResourceUnits { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Signature { get; set; }
	public System.DateTimeOffset? StartDateInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType Type { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Uid { get; set; }
}

public readonly partial struct LicenseDescriptor
{
	internal Elastic.Clients.Elasticsearch.LicenseManagement.License Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LicenseDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.License instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LicenseDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LicenseManagement.License(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.License instance) => new Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LicenseManagement.License(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor ExpiryDateInMillis(System.DateTimeOffset value)
	{
		Instance.ExpiryDateInMillis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor IssueDateInMillis(System.DateTimeOffset value)
	{
		Instance.IssueDateInMillis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor IssuedTo(string value)
	{
		Instance.IssuedTo = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor Issuer(string value)
	{
		Instance.Issuer = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor MaxNodes(long? value)
	{
		Instance.MaxNodes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor MaxResourceUnits(long? value)
	{
		Instance.MaxResourceUnits = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor Signature(string value)
	{
		Instance.Signature = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor StartDateInMillis(System.DateTimeOffset? value)
	{
		Instance.StartDateInMillis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor Type(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseType value)
	{
		Instance.Type = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor Uid(string value)
	{
		Instance.Uid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LicenseManagement.License Build(System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor(new Elastic.Clients.Elasticsearch.LicenseManagement.License(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}