// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.LatLonGeoLocationConverter))]
public sealed partial class LatLonGeoLocation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LatLonGeoLocation(double lat, double lon)
	{
		Lat = lat;
		Lon = lon;
	}
#if NET7_0_OR_GREATER
	public LatLonGeoLocation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public LatLonGeoLocation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal LatLonGeoLocation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Latitude
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Lat { get; set; }

	/// <summary>
	/// <para>
	/// Longitude
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double Lon { get; set; }
}

public readonly partial struct LatLonGeoLocationDescriptor
{
	internal Elastic.Clients.Elasticsearch.LatLonGeoLocation Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LatLonGeoLocationDescriptor(Elastic.Clients.Elasticsearch.LatLonGeoLocation instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public LatLonGeoLocationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LatLonGeoLocation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor(Elastic.Clients.Elasticsearch.LatLonGeoLocation instance) => new Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LatLonGeoLocation(Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Latitude
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor Lat(double value)
	{
		Instance.Lat = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Longitude
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor Lon(double value)
	{
		Instance.Lon = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LatLonGeoLocation Build(System.Action<Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.LatLonGeoLocationDescriptor(new Elastic.Clients.Elasticsearch.LatLonGeoLocation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}