// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.KnnSearchConverter))]
public sealed partial class KnnSearch
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnSearch(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public KnnSearch()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KnnSearch()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KnnSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Boost value to apply to kNN scores
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.InnerHits? InnerHits { get; set; }

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public int? K { get; set; }

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public int? NumCandidates { get; set; }

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<float>? QueryVector { get; set; }

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryVectorBuilder? QueryVectorBuilder { get; set; }

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RescoreVector? RescoreVector { get; set; }

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public float? Similarity { get; set; }
}

public readonly partial struct KnnSearchDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.KnnSearch Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnSearchDescriptor(Elastic.Clients.Elasticsearch.KnnSearch instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnSearchDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>(Elastic.Clients.Elasticsearch.KnnSearch instance) => new Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Boost value to apply to kNN scores
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> NumCandidates(int? value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument> Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnSearch Build(System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct KnnSearchDescriptor
{
	internal Elastic.Clients.Elasticsearch.KnnSearch Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnSearchDescriptor(Elastic.Clients.Elasticsearch.KnnSearch instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnSearchDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnSearchDescriptor(Elastic.Clients.Elasticsearch.KnnSearch instance) => new Elastic.Clients.Elasticsearch.KnnSearchDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.KnnSearchDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Boost value to apply to kNN scores
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor InnerHits(Elastic.Clients.Elasticsearch.Core.Search.InnerHits? value)
	{
		Instance.InnerHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor InnerHits()
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor InnerHits(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, each search hit will contain inner hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor InnerHits<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>>? action)
	{
		Instance.InnerHits = Elastic.Clients.Elasticsearch.Core.Search.InnerHitsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor NumCandidates(int? value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnSearchDescriptor Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnSearch Build(System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnSearchDescriptor(new Elastic.Clients.Elasticsearch.KnnSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}