// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.KnnRetrieverConverter))]
public sealed partial class KnnRetriever
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnRetriever(string field, int k, int numCandidates)
	{
		Field = field;
		K = k;
		NumCandidates = numCandidates;
	}
#if NET7_0_OR_GREATER
	public KnnRetriever()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KnnRetriever()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KnnRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Field { get; set; }

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Number of nearest neighbors to return as top hits.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int K { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public float? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public string? Name { get; set; }

	/// <summary>
	/// <para>
	/// Number of nearest neighbor candidates to consider per shard.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumCandidates { get; set; }

	/// <summary>
	/// <para>
	/// Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<float>? QueryVector { get; set; }

	/// <summary>
	/// <para>
	/// Defines a model to build a query vector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryVectorBuilder? QueryVectorBuilder { get; set; }

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RescoreVector? RescoreVector { get; set; }

	/// <summary>
	/// <para>
	/// The minimum similarity required for a document to be considered a match.
	/// </para>
	/// </summary>
	public float? Similarity { get; set; }
}

public readonly partial struct KnnRetrieverDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.KnnRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnRetrieverDescriptor(Elastic.Clients.Elasticsearch.KnnRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument>(Elastic.Clients.Elasticsearch.KnnRetriever instance) => new Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the vector field to search against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of nearest neighbors to return as top hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> K(int value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of nearest neighbor candidates to consider per shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> NumCandidates(int value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a model to build a query vector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a model to build a query vector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity required for a document to be considered a match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument> Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnRetriever Build(System.Action<Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct KnnRetrieverDescriptor
{
	internal Elastic.Clients.Elasticsearch.KnnRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnRetrieverDescriptor(Elastic.Clients.Elasticsearch.KnnRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor(Elastic.Clients.Elasticsearch.KnnRetriever instance) => new Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the vector field to search against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of nearest neighbors to return as top hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor K(int value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of nearest neighbor candidates to consider per shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor NumCandidates(int value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query vector. Must have the same number of dimensions as the vector field you are searching against. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a model to build a query vector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a model to build a query vector.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity required for a document to be considered a match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnRetriever Build(System.Action<Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnRetrieverDescriptor(new Elastic.Clients.Elasticsearch.KnnRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}