// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.KnnQueryConverter))]
public sealed partial class KnnQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public KnnQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public KnnQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal KnnQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public int? K { get; set; }

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public int? NumCandidates { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<float>? QueryVector { get; set; }

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryVectorBuilder? QueryVectorBuilder { get; set; }

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RescoreVector? RescoreVector { get; set; }

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public float? Similarity { get; set; }
}

public readonly partial struct KnnQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.KnnQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnQueryDescriptor(Elastic.Clients.Elasticsearch.KnnQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.KnnQuery instance) => new Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> NumCandidates(int? value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument> Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnQuery Build(System.Action<Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct KnnQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.KnnQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnQueryDescriptor(Elastic.Clients.Elasticsearch.KnnQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public KnnQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.KnnQueryDescriptor(Elastic.Clients.Elasticsearch.KnnQuery instance) => new Elastic.Clients.Elasticsearch.KnnQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.KnnQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the vector field to search against
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters for the kNN search query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The final number of nearest neighbors to return as top hits
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor K(int? value)
	{
		Instance.K = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nearest neighbor candidates to consider per shard
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor NumCandidates(int? value)
	{
		Instance.NumCandidates = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor QueryVector(System.Collections.Generic.ICollection<float>? value)
	{
		Instance.QueryVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor QueryVector(params float[] values)
	{
		Instance.QueryVector = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor QueryVectorBuilder(Elastic.Clients.Elasticsearch.QueryVectorBuilder? value)
	{
		Instance.QueryVectorBuilder = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query vector builder. You must provide a query_vector_builder or query_vector, but not both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor QueryVectorBuilder(System.Action<Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor> action)
	{
		Instance.QueryVectorBuilder = Elastic.Clients.Elasticsearch.QueryVectorBuilderDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor RescoreVector(Elastic.Clients.Elasticsearch.RescoreVector? value)
	{
		Instance.RescoreVector = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Apply oversampling and rescoring to quantized vectors
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor RescoreVector(System.Action<Elastic.Clients.Elasticsearch.RescoreVectorDescriptor> action)
	{
		Instance.RescoreVector = Elastic.Clients.Elasticsearch.RescoreVectorDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum similarity for a vector to be considered a match
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.KnnQueryDescriptor Similarity(float? value)
	{
		Instance.Similarity = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.KnnQuery Build(System.Action<Elastic.Clients.Elasticsearch.KnnQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.KnnQueryDescriptor(new Elastic.Clients.Elasticsearch.KnnQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}