// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class UserAgentPropertyConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDevice = System.Text.Json.JsonEncodedText.Encode("device");
	private static readonly System.Text.Json.JsonEncodedText MemberName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText MemberOriginal = System.Text.Json.JsonEncodedText.Encode("original");
	private static readonly System.Text.Json.JsonEncodedText MemberOs = System.Text.Json.JsonEncodedText.Encode("os");
	private static readonly System.Text.Json.JsonEncodedText MemberVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDevice))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Device;
		}

		if (reader.ValueTextEquals(MemberName))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Name;
		}

		if (reader.ValueTextEquals(MemberOriginal))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Original;
		}

		if (reader.ValueTextEquals(MemberOs))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Os;
		}

		if (reader.ValueTextEquals(MemberVersion))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Version;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDevice.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Device;
		}

		if (string.Equals(value, MemberName.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Name;
		}

		if (string.Equals(value, MemberOriginal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Original;
		}

		if (string.Equals(value, MemberOs.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Os;
		}

		if (string.Equals(value, MemberVersion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Version;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Device:
				writer.WriteStringValue(MemberDevice);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Name:
				writer.WriteStringValue(MemberName);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Original:
				writer.WriteStringValue(MemberOriginal);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Os:
				writer.WriteStringValue(MemberOs);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty.Version:
				writer.WriteStringValue(MemberVersion);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}