// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.UserAgentProcessorConverter))]
public sealed partial class UserAgentProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserAgentProcessor(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public UserAgentProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public UserAgentProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UserAgentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// Extracts device type from the user agent string on a best-effort basis.
	/// </para>
	/// </summary>
	public bool? ExtractDeviceType { get; set; }

	/// <summary>
	/// <para>
	/// The field containing the user agent string.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Controls what properties are added to <c>target_field</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty>? Properties { get; set; }

	/// <summary>
	/// <para>
	/// The name of the file in the <c>config/ingest-user-agent</c> directory containing the regular expressions for parsing the user agent string. Both the directory and the file have to be created before starting Elasticsearch. If not specified, ingest-user-agent will use the <c>regexes.yaml</c> from uap-core it ships with.
	/// </para>
	/// </summary>
	public string? RegexFile { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The field that will be filled with the user agent details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }
}

public readonly partial struct UserAgentProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserAgentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserAgentProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Extracts device type from the user agent string on a best-effort basis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> ExtractDeviceType(bool? value = true)
	{
		Instance.ExtractDeviceType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field containing the user agent string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field containing the user agent string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to <c>target_field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Properties(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to <c>target_field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Properties(params Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the file in the <c>config/ingest-user-agent</c> directory containing the regular expressions for parsing the user agent string. Both the directory and the file have to be created before starting Elasticsearch. If not specified, ingest-user-agent will use the <c>regexes.yaml</c> from uap-core it ships with.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> RegexFile(string? value)
	{
		Instance.RegexFile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will be filled with the user agent details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will be filled with the user agent details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct UserAgentProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserAgentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UserAgentProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Extracts device type from the user agent string on a best-effort basis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor ExtractDeviceType(bool? value = true)
	{
		Instance.ExtractDeviceType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field containing the user agent string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field containing the user agent string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to <c>target_field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Properties(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to <c>target_field</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Properties(params Elastic.Clients.Elasticsearch.Ingest.UserAgentProperty[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the file in the <c>config/ingest-user-agent</c> directory containing the regular expressions for parsing the user agent string. Both the directory and the file have to be created before starting Elasticsearch. If not specified, ingest-user-agent will use the <c>regexes.yaml</c> from uap-core it ships with.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor RegexFile(string? value)
	{
		Instance.RegexFile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will be filled with the user agent details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will be filled with the user agent details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}