// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.SetProcessorConverter))]
public sealed partial class SetProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetProcessor(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public SetProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SetProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SetProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The origin field which will be copied to <c>field</c>, cannot set <c>value</c> simultaneously.
	/// Supported data types are <c>boolean</c>, <c>number</c>, <c>array</c>, <c>object</c>, <c>string</c>, <c>date</c>, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? CopyFrom { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to insert, upsert, or update.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>value</c> is a template snippet that evaluates to <c>null</c> or the empty string, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreEmptyValue { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// The media type for encoding <c>value</c>.
	/// Applies only when value is a template snippet.
	/// Must be one of <c>application/json</c>, <c>text/plain</c>, or <c>application/x-www-form-urlencoded</c>.
	/// </para>
	/// </summary>
	public string? MediaType { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> processor will update fields with pre-existing non-null-valued field.
	/// When set to <c>false</c>, such fields will not be touched.
	/// </para>
	/// </summary>
	public bool? Override { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The value to be set for the field.
	/// Supports template snippets.
	/// May specify only one of <c>value</c> or <c>copy_from</c>.
	/// </para>
	/// </summary>
	public object? Value { get; set; }
}

public readonly partial struct SetProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.SetProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.SetProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.SetProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The origin field which will be copied to <c>field</c>, cannot set <c>value</c> simultaneously.
	/// Supported data types are <c>boolean</c>, <c>number</c>, <c>array</c>, <c>object</c>, <c>string</c>, <c>date</c>, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> CopyFrom(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.CopyFrom = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin field which will be copied to <c>field</c>, cannot set <c>value</c> simultaneously.
	/// Supported data types are <c>boolean</c>, <c>number</c>, <c>array</c>, <c>object</c>, <c>string</c>, <c>date</c>, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> CopyFrom(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.CopyFrom = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to insert, upsert, or update.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to insert, upsert, or update.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>value</c> is a template snippet that evaluates to <c>null</c> or the empty string, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> IgnoreEmptyValue(bool? value = true)
	{
		Instance.IgnoreEmptyValue = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The media type for encoding <c>value</c>.
	/// Applies only when value is a template snippet.
	/// Must be one of <c>application/json</c>, <c>text/plain</c>, or <c>application/x-www-form-urlencoded</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> MediaType(string? value)
	{
		Instance.MediaType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> processor will update fields with pre-existing non-null-valued field.
	/// When set to <c>false</c>, such fields will not be touched.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Override(bool? value = true)
	{
		Instance.Override = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to be set for the field.
	/// Supports template snippets.
	/// May specify only one of <c>value</c> or <c>copy_from</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument> Value(object? value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.SetProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SetProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.SetProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.SetProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SetProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.SetProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The origin field which will be copied to <c>field</c>, cannot set <c>value</c> simultaneously.
	/// Supported data types are <c>boolean</c>, <c>number</c>, <c>array</c>, <c>object</c>, <c>string</c>, <c>date</c>, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor CopyFrom(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.CopyFrom = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The origin field which will be copied to <c>field</c>, cannot set <c>value</c> simultaneously.
	/// Supported data types are <c>boolean</c>, <c>number</c>, <c>array</c>, <c>object</c>, <c>string</c>, <c>date</c>, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor CopyFrom<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.CopyFrom = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to insert, upsert, or update.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to insert, upsert, or update.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>value</c> is a template snippet that evaluates to <c>null</c> or the empty string, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor IgnoreEmptyValue(bool? value = true)
	{
		Instance.IgnoreEmptyValue = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The media type for encoding <c>value</c>.
	/// Applies only when value is a template snippet.
	/// Must be one of <c>application/json</c>, <c>text/plain</c>, or <c>application/x-www-form-urlencoded</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor MediaType(string? value)
	{
		Instance.MediaType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> processor will update fields with pre-existing non-null-valued field.
	/// When set to <c>false</c>, such fields will not be touched.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Override(bool? value = true)
	{
		Instance.Override = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value to be set for the field.
	/// Supports template snippets.
	/// May specify only one of <c>value</c> or <c>copy_from</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor Value(object? value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.SetProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.SetProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.SetProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}