// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.RerouteProcessorConverter))]
public sealed partial class RerouteProcessor
{
#if NET7_0_OR_GREATER
	public RerouteProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RerouteProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the dataset part of the data stream name.
	/// In addition to the criteria for index names, cannot contain - and must be no longer than 100 characters.
	/// Example values are nginx.access and nginx.error.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;dataset> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.dataset}}
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Dataset { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// A static value for the target. Can’t be set when the dataset or namespace option is set.
	/// </para>
	/// </summary>
	public string? Destination { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// Field references or a static value for the namespace part of the data stream name. See the criteria for
	/// index names for allowed characters. Must be no longer than 100 characters.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;namespace> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.namespace}}
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Namespace { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }
}

public readonly partial struct RerouteProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RerouteProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RerouteProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Field references or a static value for the dataset part of the data stream name.
	/// In addition to the criteria for index names, cannot contain - and must be no longer than 100 characters.
	/// Example values are nginx.access and nginx.error.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;dataset> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.dataset}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Dataset(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Dataset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the dataset part of the data stream name.
	/// In addition to the criteria for index names, cannot contain - and must be no longer than 100 characters.
	/// Example values are nginx.access and nginx.error.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;dataset> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.dataset}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Dataset(params string[] values)
	{
		Instance.Dataset = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A static value for the target. Can’t be set when the dataset or namespace option is set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Destination(string? value)
	{
		Instance.Destination = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the namespace part of the data stream name. See the criteria for
	/// index names for allowed characters. Must be no longer than 100 characters.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;namespace> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.namespace}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Namespace(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Namespace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the namespace part of the data stream name. See the criteria for
	/// index names for allowed characters. Must be no longer than 100 characters.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;namespace> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.namespace}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Namespace(params string[] values)
	{
		Instance.Namespace = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RerouteProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RerouteProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RerouteProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Field references or a static value for the dataset part of the data stream name.
	/// In addition to the criteria for index names, cannot contain - and must be no longer than 100 characters.
	/// Example values are nginx.access and nginx.error.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;dataset> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.dataset}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Dataset(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Dataset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the dataset part of the data stream name.
	/// In addition to the criteria for index names, cannot contain - and must be no longer than 100 characters.
	/// Example values are nginx.access and nginx.error.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;dataset> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.dataset}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Dataset(params string[] values)
	{
		Instance.Dataset = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A static value for the target. Can’t be set when the dataset or namespace option is set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Destination(string? value)
	{
		Instance.Destination = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the namespace part of the data stream name. See the criteria for
	/// index names for allowed characters. Must be no longer than 100 characters.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;namespace> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.namespace}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Namespace(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Namespace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field references or a static value for the namespace part of the data stream name. See the criteria for
	/// index names for allowed characters. Must be no longer than 100 characters.
	/// </para>
	/// <para>
	/// Supports field references with a mustache-like syntax (denoted as {{double}} or {{{triple}}} curly braces).
	/// When resolving field references, the processor replaces invalid characters with _. Uses the &lt;namespace> part
	/// of the index name as a fallback if all field references resolve to a null, missing, or non-string value.
	/// </para>
	/// <para>
	/// default {{data_stream.namespace}}
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Namespace(params string[] values)
	{
		Instance.Namespace = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}