// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.RedactProcessorConverter))]
public sealed partial class RedactProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RedactProcessor(Elastic.Clients.Elasticsearch.Field field, System.Collections.Generic.ICollection<string> patterns)
	{
		Field = field;
		Patterns = patterns;
	}
#if NET7_0_OR_GREATER
	public RedactProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RedactProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RedactProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to be redacted
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist or is <c>null</c>, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }
	public System.Collections.Generic.IDictionary<string, string>? PatternDefinitions { get; set; }

	/// <summary>
	/// <para>
	/// A list of grok expressions to match and redact named captures with
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Patterns { get; set; }

	/// <summary>
	/// <para>
	/// Start a redacted section with this token
	/// </para>
	/// </summary>
	public string? Prefix { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and the current license does not support running redact processors, then the processor quietly exits without modifying the document
	/// </para>
	/// </summary>
	public bool? SkipIfUnlicensed { get; set; }

	/// <summary>
	/// <para>
	/// End a redacted section with this token
	/// </para>
	/// </summary>
	public string? Suffix { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> then ingest metadata <c>_ingest._redact._is_redacted</c> is set to <c>true</c> if the document has been redacted
	/// </para>
	/// </summary>
	public bool? TraceRedact { get; set; }
}

public readonly partial struct RedactProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.RedactProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RedactProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RedactProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RedactProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.RedactProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist or is <c>null</c>, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> PatternDefinitions(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.PatternDefinitions = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> PatternDefinitions()
	{
		Instance.PatternDefinitions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> PatternDefinitions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.PatternDefinitions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> AddPatternDefinition(string key, string value)
	{
		Instance.PatternDefinitions ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.PatternDefinitions.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of grok expressions to match and redact named captures with
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Patterns(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Patterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of grok expressions to match and redact named captures with
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Patterns(params string[] values)
	{
		Instance.Patterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Start a redacted section with this token
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Prefix(string? value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and the current license does not support running redact processors, then the processor quietly exits without modifying the document
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> SkipIfUnlicensed(bool? value = true)
	{
		Instance.SkipIfUnlicensed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End a redacted section with this token
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Suffix(string? value)
	{
		Instance.Suffix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> then ingest metadata <c>_ingest._redact._is_redacted</c> is set to <c>true</c> if the document has been redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument> TraceRedact(bool? value = true)
	{
		Instance.TraceRedact = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.RedactProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct RedactProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.RedactProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RedactProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RedactProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RedactProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.RedactProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist or is <c>null</c>, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor PatternDefinitions(System.Collections.Generic.IDictionary<string, string>? value)
	{
		Instance.PatternDefinitions = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor PatternDefinitions()
	{
		Instance.PatternDefinitions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor PatternDefinitions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString>? action)
	{
		Instance.PatternDefinitions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor AddPatternDefinition(string key, string value)
	{
		Instance.PatternDefinitions ??= new System.Collections.Generic.Dictionary<string, string>();
		Instance.PatternDefinitions.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of grok expressions to match and redact named captures with
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Patterns(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Patterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of grok expressions to match and redact named captures with
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Patterns(params string[] values)
	{
		Instance.Patterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Start a redacted section with this token
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Prefix(string? value)
	{
		Instance.Prefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and the current license does not support running redact processors, then the processor quietly exits without modifying the document
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor SkipIfUnlicensed(bool? value = true)
	{
		Instance.SkipIfUnlicensed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// End a redacted section with this token
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Suffix(string? value)
	{
		Instance.Suffix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> then ingest metadata <c>_ingest._redact._is_redacted</c> is set to <c>true</c> if the document has been redacted
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor TraceRedact(bool? value = true)
	{
		Instance.TraceRedact = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.RedactProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.RedactProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.RedactProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}