// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class ProcessorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.Processor>
{
	private static readonly System.Text.Json.JsonEncodedText VariantAppend = System.Text.Json.JsonEncodedText.Encode("append");
	private static readonly System.Text.Json.JsonEncodedText VariantAttachment = System.Text.Json.JsonEncodedText.Encode("attachment");
	private static readonly System.Text.Json.JsonEncodedText VariantBytes = System.Text.Json.JsonEncodedText.Encode("bytes");
	private static readonly System.Text.Json.JsonEncodedText VariantCircle = System.Text.Json.JsonEncodedText.Encode("circle");
	private static readonly System.Text.Json.JsonEncodedText VariantCommunityId = System.Text.Json.JsonEncodedText.Encode("community_id");
	private static readonly System.Text.Json.JsonEncodedText VariantConvert = System.Text.Json.JsonEncodedText.Encode("convert");
	private static readonly System.Text.Json.JsonEncodedText VariantCsv = System.Text.Json.JsonEncodedText.Encode("csv");
	private static readonly System.Text.Json.JsonEncodedText VariantDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText VariantDateIndexName = System.Text.Json.JsonEncodedText.Encode("date_index_name");
	private static readonly System.Text.Json.JsonEncodedText VariantDissect = System.Text.Json.JsonEncodedText.Encode("dissect");
	private static readonly System.Text.Json.JsonEncodedText VariantDotExpander = System.Text.Json.JsonEncodedText.Encode("dot_expander");
	private static readonly System.Text.Json.JsonEncodedText VariantDrop = System.Text.Json.JsonEncodedText.Encode("drop");
	private static readonly System.Text.Json.JsonEncodedText VariantEnrich = System.Text.Json.JsonEncodedText.Encode("enrich");
	private static readonly System.Text.Json.JsonEncodedText VariantFail = System.Text.Json.JsonEncodedText.Encode("fail");
	private static readonly System.Text.Json.JsonEncodedText VariantFingerprint = System.Text.Json.JsonEncodedText.Encode("fingerprint");
	private static readonly System.Text.Json.JsonEncodedText VariantForeach = System.Text.Json.JsonEncodedText.Encode("foreach");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoGrid = System.Text.Json.JsonEncodedText.Encode("geo_grid");
	private static readonly System.Text.Json.JsonEncodedText VariantGeoip = System.Text.Json.JsonEncodedText.Encode("geoip");
	private static readonly System.Text.Json.JsonEncodedText VariantGrok = System.Text.Json.JsonEncodedText.Encode("grok");
	private static readonly System.Text.Json.JsonEncodedText VariantGsub = System.Text.Json.JsonEncodedText.Encode("gsub");
	private static readonly System.Text.Json.JsonEncodedText VariantHtmlStrip = System.Text.Json.JsonEncodedText.Encode("html_strip");
	private static readonly System.Text.Json.JsonEncodedText VariantInference = System.Text.Json.JsonEncodedText.Encode("inference");
	private static readonly System.Text.Json.JsonEncodedText VariantIpLocation = System.Text.Json.JsonEncodedText.Encode("ip_location");
	private static readonly System.Text.Json.JsonEncodedText VariantJoin = System.Text.Json.JsonEncodedText.Encode("join");
	private static readonly System.Text.Json.JsonEncodedText VariantJson = System.Text.Json.JsonEncodedText.Encode("json");
	private static readonly System.Text.Json.JsonEncodedText VariantKv = System.Text.Json.JsonEncodedText.Encode("kv");
	private static readonly System.Text.Json.JsonEncodedText VariantLowercase = System.Text.Json.JsonEncodedText.Encode("lowercase");
	private static readonly System.Text.Json.JsonEncodedText VariantNetworkDirection = System.Text.Json.JsonEncodedText.Encode("network_direction");
	private static readonly System.Text.Json.JsonEncodedText VariantPipeline = System.Text.Json.JsonEncodedText.Encode("pipeline");
	private static readonly System.Text.Json.JsonEncodedText VariantRedact = System.Text.Json.JsonEncodedText.Encode("redact");
	private static readonly System.Text.Json.JsonEncodedText VariantRegisteredDomain = System.Text.Json.JsonEncodedText.Encode("registered_domain");
	private static readonly System.Text.Json.JsonEncodedText VariantRemove = System.Text.Json.JsonEncodedText.Encode("remove");
	private static readonly System.Text.Json.JsonEncodedText VariantRename = System.Text.Json.JsonEncodedText.Encode("rename");
	private static readonly System.Text.Json.JsonEncodedText VariantReroute = System.Text.Json.JsonEncodedText.Encode("reroute");
	private static readonly System.Text.Json.JsonEncodedText VariantScript = System.Text.Json.JsonEncodedText.Encode("script");
	private static readonly System.Text.Json.JsonEncodedText VariantSet = System.Text.Json.JsonEncodedText.Encode("set");
	private static readonly System.Text.Json.JsonEncodedText VariantSetSecurityUser = System.Text.Json.JsonEncodedText.Encode("set_security_user");
	private static readonly System.Text.Json.JsonEncodedText VariantSort = System.Text.Json.JsonEncodedText.Encode("sort");
	private static readonly System.Text.Json.JsonEncodedText VariantSplit = System.Text.Json.JsonEncodedText.Encode("split");
	private static readonly System.Text.Json.JsonEncodedText VariantTerminate = System.Text.Json.JsonEncodedText.Encode("terminate");
	private static readonly System.Text.Json.JsonEncodedText VariantTrim = System.Text.Json.JsonEncodedText.Encode("trim");
	private static readonly System.Text.Json.JsonEncodedText VariantUppercase = System.Text.Json.JsonEncodedText.Encode("uppercase");
	private static readonly System.Text.Json.JsonEncodedText VariantUriParts = System.Text.Json.JsonEncodedText.Encode("uri_parts");
	private static readonly System.Text.Json.JsonEncodedText VariantUrlDecode = System.Text.Json.JsonEncodedText.Encode("urldecode");
	private static readonly System.Text.Json.JsonEncodedText VariantUserAgent = System.Text.Json.JsonEncodedText.Encode("user_agent");

	public override Elastic.Clients.Elasticsearch.Ingest.Processor Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantAppend))
			{
				variantType = VariantAppend.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.AppendProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantAttachment))
			{
				variantType = VariantAttachment.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantBytes))
			{
				variantType = VariantBytes.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.BytesProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCircle))
			{
				variantType = VariantCircle.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.CircleProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCommunityId))
			{
				variantType = VariantCommunityId.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantConvert))
			{
				variantType = VariantConvert.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.ConvertProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantCsv))
			{
				variantType = VariantCsv.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.CsvProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDate))
			{
				variantType = VariantDate.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.DateProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDateIndexName))
			{
				variantType = VariantDateIndexName.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDissect))
			{
				variantType = VariantDissect.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.DissectProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDotExpander))
			{
				variantType = VariantDotExpander.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.DotExpanderProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantDrop))
			{
				variantType = VariantDrop.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.DropProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantEnrich))
			{
				variantType = VariantEnrich.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.EnrichProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFail))
			{
				variantType = VariantFail.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.FailProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFingerprint))
			{
				variantType = VariantFingerprint.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.FingerprintProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantForeach))
			{
				variantType = VariantForeach.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.ForeachProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoGrid))
			{
				variantType = VariantGeoGrid.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGeoip))
			{
				variantType = VariantGeoip.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.GeoIpProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGrok))
			{
				variantType = VariantGrok.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.GrokProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGsub))
			{
				variantType = VariantGsub.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.GsubProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantHtmlStrip))
			{
				variantType = VariantHtmlStrip.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.HtmlStripProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantInference))
			{
				variantType = VariantInference.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantIpLocation))
			{
				variantType = VariantIpLocation.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantJoin))
			{
				variantType = VariantJoin.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.JoinProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantJson))
			{
				variantType = VariantJson.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.JsonProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantKv))
			{
				variantType = VariantKv.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.KeyValueProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLowercase))
			{
				variantType = VariantLowercase.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.LowercaseProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantNetworkDirection))
			{
				variantType = VariantNetworkDirection.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.NetworkDirectionProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantPipeline))
			{
				variantType = VariantPipeline.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.PipelineProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRedact))
			{
				variantType = VariantRedact.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.RedactProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRegisteredDomain))
			{
				variantType = VariantRegisteredDomain.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.RegisteredDomainProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRemove))
			{
				variantType = VariantRemove.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.RemoveProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRename))
			{
				variantType = VariantRename.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.RenameProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantReroute))
			{
				variantType = VariantReroute.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScript))
			{
				variantType = VariantScript.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.ScriptProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSet))
			{
				variantType = VariantSet.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.SetProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSetSecurityUser))
			{
				variantType = VariantSetSecurityUser.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.SetSecurityUserProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSort))
			{
				variantType = VariantSort.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.SortProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantSplit))
			{
				variantType = VariantSplit.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.SplitProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTerminate))
			{
				variantType = VariantTerminate.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.TerminateProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantTrim))
			{
				variantType = VariantTrim.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.TrimProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantUppercase))
			{
				variantType = VariantUppercase.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.UppercaseProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantUriParts))
			{
				variantType = VariantUriParts.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.UriPartsProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantUrlDecode))
			{
				variantType = VariantUrlDecode.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.UrlDecodeProcessor>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantUserAgent))
			{
				variantType = VariantUserAgent.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Ingest.Processor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.Processor value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "append":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.AppendProcessor)value.Variant, null, null);
				break;
			case "attachment":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor)value.Variant, null, null);
				break;
			case "bytes":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.BytesProcessor)value.Variant, null, null);
				break;
			case "circle":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.CircleProcessor)value.Variant, null, null);
				break;
			case "community_id":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor)value.Variant, null, null);
				break;
			case "convert":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.ConvertProcessor)value.Variant, null, null);
				break;
			case "csv":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.CsvProcessor)value.Variant, null, null);
				break;
			case "date":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.DateProcessor)value.Variant, null, null);
				break;
			case "date_index_name":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor)value.Variant, null, null);
				break;
			case "dissect":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.DissectProcessor)value.Variant, null, null);
				break;
			case "dot_expander":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.DotExpanderProcessor)value.Variant, null, null);
				break;
			case "drop":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.DropProcessor)value.Variant, null, null);
				break;
			case "enrich":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.EnrichProcessor)value.Variant, null, null);
				break;
			case "fail":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.FailProcessor)value.Variant, null, null);
				break;
			case "fingerprint":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.FingerprintProcessor)value.Variant, null, null);
				break;
			case "foreach":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.ForeachProcessor)value.Variant, null, null);
				break;
			case "geo_grid":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor)value.Variant, null, null);
				break;
			case "geoip":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.GeoIpProcessor)value.Variant, null, null);
				break;
			case "grok":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.GrokProcessor)value.Variant, null, null);
				break;
			case "gsub":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.GsubProcessor)value.Variant, null, null);
				break;
			case "html_strip":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.HtmlStripProcessor)value.Variant, null, null);
				break;
			case "inference":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor)value.Variant, null, null);
				break;
			case "ip_location":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor)value.Variant, null, null);
				break;
			case "join":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.JoinProcessor)value.Variant, null, null);
				break;
			case "json":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.JsonProcessor)value.Variant, null, null);
				break;
			case "kv":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.KeyValueProcessor)value.Variant, null, null);
				break;
			case "lowercase":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.LowercaseProcessor)value.Variant, null, null);
				break;
			case "network_direction":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.NetworkDirectionProcessor)value.Variant, null, null);
				break;
			case "pipeline":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.PipelineProcessor)value.Variant, null, null);
				break;
			case "redact":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.RedactProcessor)value.Variant, null, null);
				break;
			case "registered_domain":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.RegisteredDomainProcessor)value.Variant, null, null);
				break;
			case "remove":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.RemoveProcessor)value.Variant, null, null);
				break;
			case "rename":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.RenameProcessor)value.Variant, null, null);
				break;
			case "reroute":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.RerouteProcessor)value.Variant, null, null);
				break;
			case "script":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.ScriptProcessor)value.Variant, null, null);
				break;
			case "set":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.SetProcessor)value.Variant, null, null);
				break;
			case "set_security_user":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.SetSecurityUserProcessor)value.Variant, null, null);
				break;
			case "sort":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.SortProcessor)value.Variant, null, null);
				break;
			case "split":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.SplitProcessor)value.Variant, null, null);
				break;
			case "terminate":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.TerminateProcessor)value.Variant, null, null);
				break;
			case "trim":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.TrimProcessor)value.Variant, null, null);
				break;
			case "uppercase":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.UppercaseProcessor)value.Variant, null, null);
				break;
			case "uri_parts":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.UriPartsProcessor)value.Variant, null, null);
				break;
			case "urldecode":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.UrlDecodeProcessor)value.Variant, null, null);
				break;
			case "user_agent":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.Ingest.UserAgentProcessor)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Ingest.Processor)}'.");
		}

		writer.WriteEndObject();
	}
}