// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class PipelineProcessorResultConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.PipelineProcessorResult>
{
	private static readonly System.Text.Json.JsonEncodedText PropDescription = System.Text.Json.JsonEncodedText.Encode("description");
	private static readonly System.Text.Json.JsonEncodedText PropDoc = System.Text.Json.JsonEncodedText.Encode("doc");
	private static readonly System.Text.Json.JsonEncodedText PropError = System.Text.Json.JsonEncodedText.Encode("error");
	private static readonly System.Text.Json.JsonEncodedText PropIgnoredError = System.Text.Json.JsonEncodedText.Encode("ignored_error");
	private static readonly System.Text.Json.JsonEncodedText PropProcessorType = System.Text.Json.JsonEncodedText.Encode("processor_type");
	private static readonly System.Text.Json.JsonEncodedText PropStatus = System.Text.Json.JsonEncodedText.Encode("status");
	private static readonly System.Text.Json.JsonEncodedText PropTag = System.Text.Json.JsonEncodedText.Encode("tag");

	public override Elastic.Clients.Elasticsearch.Ingest.PipelineProcessorResult Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propDescription = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Ingest.DocumentSimulation?> propDoc = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ErrorCause?> propError = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ErrorCause?> propIgnoredError = default;
		LocalJsonValue<string?> propProcessorType = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Ingest.PipelineSimulationStatusOptions?> propStatus = default;
		LocalJsonValue<string?> propTag = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDescription.TryReadProperty(ref reader, options, PropDescription, null))
			{
				continue;
			}

			if (propDoc.TryReadProperty(ref reader, options, PropDoc, null))
			{
				continue;
			}

			if (propError.TryReadProperty(ref reader, options, PropError, null))
			{
				continue;
			}

			if (propIgnoredError.TryReadProperty(ref reader, options, PropIgnoredError, null))
			{
				continue;
			}

			if (propProcessorType.TryReadProperty(ref reader, options, PropProcessorType, null))
			{
				continue;
			}

			if (propStatus.TryReadProperty(ref reader, options, PropStatus, static Elastic.Clients.Elasticsearch.Ingest.PipelineSimulationStatusOptions? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Ingest.PipelineSimulationStatusOptions>(o)))
			{
				continue;
			}

			if (propTag.TryReadProperty(ref reader, options, PropTag, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Ingest.PipelineProcessorResult(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Description = propDescription.Value,
			Doc = propDoc.Value,
			Error = propError.Value,
			IgnoredError = propIgnoredError.Value,
			ProcessorType = propProcessorType.Value,
			Status = propStatus.Value,
			Tag = propTag.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.PipelineProcessorResult value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDescription, value.Description, null, null);
		writer.WriteProperty(options, PropDoc, value.Doc, null, null);
		writer.WriteProperty(options, PropError, value.Error, null, null);
		writer.WriteProperty(options, PropIgnoredError, value.IgnoredError, null, null);
		writer.WriteProperty(options, PropProcessorType, value.ProcessorType, null, null);
		writer.WriteProperty(options, PropStatus, value.Status, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Ingest.PipelineSimulationStatusOptions? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Ingest.PipelineSimulationStatusOptions>(o, v));
		writer.WriteProperty(options, PropTag, value.Tag, null, null);
		writer.WriteEndObject();
	}
}