// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class JsonProcessorConflictStrategyConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy>
{
	private static readonly System.Text.Json.JsonEncodedText MemberMerge = System.Text.Json.JsonEncodedText.Encode("merge");
	private static readonly System.Text.Json.JsonEncodedText MemberReplace = System.Text.Json.JsonEncodedText.Encode("replace");

	public override Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberMerge))
		{
			return Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Merge;
		}

		if (reader.ValueTextEquals(MemberReplace))
		{
			return Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Replace;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberMerge.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Merge;
		}

		if (string.Equals(value, MemberReplace.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Replace;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Merge:
				writer.WriteStringValue(MemberMerge);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy.Replace:
				writer.WriteStringValue(MemberReplace);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}