// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.JsonProcessorConverter))]
public sealed partial class JsonProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JsonProcessor(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public JsonProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public JsonProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JsonProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Flag that forces the parsed JSON to be added at the top level of the document.
	/// <c>target_field</c> must not be set when this option is chosen.
	/// </para>
	/// </summary>
	public bool? AddToRoot { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>replace</c>, root fields that conflict with fields from the parsed JSON will be overridden.
	/// When set to <c>merge</c>, conflicting fields will be merged.
	/// Only applicable <c>if add_to_root</c> is set to true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy? AddToRootConflictStrategy { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, the JSON parser will not fail if the JSON contains duplicate keys.
	/// Instead, the last encountered value for any duplicate key wins.
	/// </para>
	/// </summary>
	public bool? AllowDuplicateKeys { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to be parsed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The field that the converted structured object will be written into.
	/// Any existing content in this field will be overwritten.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }
}

public readonly partial struct JsonProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.JsonProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JsonProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.JsonProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JsonProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.JsonProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Flag that forces the parsed JSON to be added at the top level of the document.
	/// <c>target_field</c> must not be set when this option is chosen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> AddToRoot(bool? value = true)
	{
		Instance.AddToRoot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>replace</c>, root fields that conflict with fields from the parsed JSON will be overridden.
	/// When set to <c>merge</c>, conflicting fields will be merged.
	/// Only applicable <c>if add_to_root</c> is set to true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> AddToRootConflictStrategy(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy? value)
	{
		Instance.AddToRootConflictStrategy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, the JSON parser will not fail if the JSON contains duplicate keys.
	/// Instead, the last encountered value for any duplicate key wins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> AllowDuplicateKeys(bool? value = true)
	{
		Instance.AllowDuplicateKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be parsed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be parsed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that the converted structured object will be written into.
	/// Any existing content in this field will be overwritten.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that the converted structured object will be written into.
	/// Any existing content in this field will be overwritten.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.JsonProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct JsonProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.JsonProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JsonProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.JsonProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public JsonProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.JsonProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Flag that forces the parsed JSON to be added at the top level of the document.
	/// <c>target_field</c> must not be set when this option is chosen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor AddToRoot(bool? value = true)
	{
		Instance.AddToRoot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>replace</c>, root fields that conflict with fields from the parsed JSON will be overridden.
	/// When set to <c>merge</c>, conflicting fields will be merged.
	/// Only applicable <c>if add_to_root</c> is set to true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor AddToRootConflictStrategy(Elastic.Clients.Elasticsearch.Ingest.JsonProcessorConflictStrategy? value)
	{
		Instance.AddToRootConflictStrategy = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c>, the JSON parser will not fail if the JSON contains duplicate keys.
	/// Instead, the last encountered value for any duplicate key wins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor AllowDuplicateKeys(bool? value = true)
	{
		Instance.AllowDuplicateKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be parsed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to be parsed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that the converted structured object will be written into.
	/// Any existing content in this field will be overwritten.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that the converted structured object will be written into.
	/// Any existing content in this field will be overwritten.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.JsonProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.JsonProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.JsonProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}