// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.IpLocationProcessorConverter))]
public sealed partial class IpLocationProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpLocationProcessor(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public IpLocationProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IpLocationProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IpLocationProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The database filename referring to a database the module ships with (GeoLite2-City.mmdb, GeoLite2-Country.mmdb, or GeoLite2-ASN.mmdb) or a custom database in the ingest-geoip config directory.
	/// </para>
	/// </summary>
	public string? DatabaseFile { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> (and if <c>ingest.geoip.downloader.eager.download</c> is <c>false</c>), the missing database is downloaded when the pipeline is created.
	/// Else, the download is triggered by when the pipeline is used as the <c>default_pipeline</c> or <c>final_pipeline</c> in an index.
	/// </para>
	/// </summary>
	public bool? DownloadDatabaseOnPipelineCreation { get; set; }

	/// <summary>
	/// <para>
	/// The field to get the ip address from for the geographical lookup.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, only the first found IP location data will be returned, even if the field contains an array.
	/// </para>
	/// </summary>
	public bool? FirstOnly { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Controls what properties are added to the <c>target_field</c> based on the IP location lookup.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Properties { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The field that will hold the geographical information looked up from the MaxMind database.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }
}

public readonly partial struct IpLocationProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpLocationProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpLocationProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The database filename referring to a database the module ships with (GeoLite2-City.mmdb, GeoLite2-Country.mmdb, or GeoLite2-ASN.mmdb) or a custom database in the ingest-geoip config directory.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> DatabaseFile(string? value)
	{
		Instance.DatabaseFile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (and if <c>ingest.geoip.downloader.eager.download</c> is <c>false</c>), the missing database is downloaded when the pipeline is created.
	/// Else, the download is triggered by when the pipeline is used as the <c>default_pipeline</c> or <c>final_pipeline</c> in an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> DownloadDatabaseOnPipelineCreation(bool? value = true)
	{
		Instance.DownloadDatabaseOnPipelineCreation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the ip address from for the geographical lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the ip address from for the geographical lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, only the first found IP location data will be returned, even if the field contains an array.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> FirstOnly(bool? value = true)
	{
		Instance.FirstOnly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to the <c>target_field</c> based on the IP location lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Properties(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to the <c>target_field</c> based on the IP location lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Properties(params string[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the geographical information looked up from the MaxMind database.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the geographical information looked up from the MaxMind database.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IpLocationProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpLocationProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IpLocationProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The database filename referring to a database the module ships with (GeoLite2-City.mmdb, GeoLite2-Country.mmdb, or GeoLite2-ASN.mmdb) or a custom database in the ingest-geoip config directory.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor DatabaseFile(string? value)
	{
		Instance.DatabaseFile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (and if <c>ingest.geoip.downloader.eager.download</c> is <c>false</c>), the missing database is downloaded when the pipeline is created.
	/// Else, the download is triggered by when the pipeline is used as the <c>default_pipeline</c> or <c>final_pipeline</c> in an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor DownloadDatabaseOnPipelineCreation(bool? value = true)
	{
		Instance.DownloadDatabaseOnPipelineCreation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the ip address from for the geographical lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the ip address from for the geographical lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, only the first found IP location data will be returned, even if the field contains an array.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor FirstOnly(bool? value = true)
	{
		Instance.FirstOnly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to the <c>target_field</c> based on the IP location lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Properties(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls what properties are added to the <c>target_field</c> based on the IP location lookup.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Properties(params string[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the geographical information looked up from the MaxMind database.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the geographical information looked up from the MaxMind database.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.IpLocationProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}