// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.InferenceProcessorConverter))]
public sealed partial class InferenceProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceProcessor(Elastic.Clients.Elasticsearch.Id modelId)
	{
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public InferenceProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public InferenceProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, object>? FieldMap { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If true and any of the input fields defined in input_ouput are missing
	/// then those missing fields are quietly ignored, otherwise a missing field causes a failure.
	/// Only applies when using input_output configurations to explicitly list the input fields.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfig? InferenceConfig { get; set; }

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.InputConfig>? InputOutput { get; set; }

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model, or the ID of the deployment.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id ModelId { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// Field added to incoming documents to contain results objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }
}

public readonly partial struct InferenceProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> FieldMap(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, object>? value)
	{
		Instance.FieldMap = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> FieldMap()
	{
		Instance.FieldMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> FieldMap(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject<TDocument>>? action)
	{
		Instance.FieldMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> AddFieldMap(Elastic.Clients.Elasticsearch.Field key, object value)
	{
		Instance.FieldMap ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, object>();
		Instance.FieldMap.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> AddFieldMap(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, object value)
	{
		Instance.FieldMap ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, object>();
		Instance.FieldMap.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true and any of the input fields defined in input_ouput are missing
	/// then those missing fields are quietly ignored, otherwise a missing field causes a failure.
	/// Only applies when using input_output configurations to explicitly list the input fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> InputOutput(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.InputConfig>? value)
	{
		Instance.InputOutput = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> InputOutput(params Elastic.Clients.Elasticsearch.Ingest.InputConfig[] values)
	{
		Instance.InputOutput = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> InputOutput(params System.Action<Elastic.Clients.Elasticsearch.Ingest.InputConfigDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.InputConfig>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.InputConfigDescriptor.Build(action));
		}

		Instance.InputOutput = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model, or the ID of the deployment.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field added to incoming documents to contain results objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field added to incoming documents to contain results objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor FieldMap(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, object>? value)
	{
		Instance.FieldMap = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor FieldMap()
	{
		Instance.FieldMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor FieldMap(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject>? action)
	{
		Instance.FieldMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maps the document field names to the known field names of the model.
	/// This mapping takes precedence over any default mappings provided in the model configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor FieldMap<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject<T>>? action)
	{
		Instance.FieldMap = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldObject<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor AddFieldMap(Elastic.Clients.Elasticsearch.Field key, object value)
	{
		Instance.FieldMap ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, object>();
		Instance.FieldMap.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor AddFieldMap<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, object value)
	{
		Instance.FieldMap ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, object>();
		Instance.FieldMap.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true and any of the input fields defined in input_ouput are missing
	/// then those missing fields are quietly ignored, otherwise a missing field causes a failure.
	/// Only applies when using input_output configurations to explicitly list the input fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Contains the inference type and its options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InferenceConfig<T>(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<T>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InputOutput(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.InputConfig>? value)
	{
		Instance.InputOutput = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InputOutput(params Elastic.Clients.Elasticsearch.Ingest.InputConfig[] values)
	{
		Instance.InputOutput = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Input fields for inference and output (destination) fields for the inference results.
	/// This option is incompatible with the target_field and field_map options.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor InputOutput(params System.Action<Elastic.Clients.Elasticsearch.Ingest.InputConfigDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.InputConfig>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.InputConfigDescriptor.Build(action));
		}

		Instance.InputOutput = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID or alias for the trained model, or the ID of the deployment.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field added to incoming documents to contain results objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field added to incoming documents to contain results objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.InferenceProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}