// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.InferenceConfigRegressionConverter))]
public sealed partial class InferenceConfigRegression
{
#if NET7_0_OR_GREATER
	public InferenceConfigRegression()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceConfigRegression()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public int? NumTopFeatureImportanceValues { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? ResultsField { get; set; }
}

public readonly partial struct InferenceConfigRegressionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigRegressionDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigRegressionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument> NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument> ResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument> ResultsField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ResultsField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceConfigRegressionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigRegressionDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigRegressionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor ResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor ResultsField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ResultsField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}