// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.InferenceConfigClassificationConverter))]
public sealed partial class InferenceConfigClassification
{
#if NET7_0_OR_GREATER
	public InferenceConfigClassification()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceConfigClassification()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return.
	/// </para>
	/// </summary>
	public int? NumTopClasses { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public int? NumTopFeatureImportanceValues { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the type of the predicted field to write.
	/// Valid values are: <c>string</c>, <c>number</c>, <c>boolean</c>.
	/// </para>
	/// </summary>
	public string? PredictionFieldType { get; set; }

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? ResultsField { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TopClassesResultsField { get; set; }
}

public readonly partial struct InferenceConfigClassificationDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigClassificationDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the type of the predicted field to write.
	/// Valid values are: <c>string</c>, <c>number</c>, <c>boolean</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> PredictionFieldType(string? value)
	{
		Instance.PredictionFieldType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> ResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> ResultsField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> TopClassesResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TopClassesResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument> TopClassesResultsField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TopClassesResultsField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceConfigClassificationDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigClassificationDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigClassificationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies the number of top class predictions to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor NumTopClasses(int? value)
	{
		Instance.NumTopClasses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of feature importance values per document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor NumTopFeatureImportanceValues(int? value)
	{
		Instance.NumTopFeatureImportanceValues = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the type of the predicted field to write.
	/// Valid values are: <c>string</c>, <c>number</c>, <c>boolean</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor PredictionFieldType(string? value)
	{
		Instance.PredictionFieldType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor ResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that is added to incoming documents to contain the inference prediction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor ResultsField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor TopClassesResultsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TopClassesResultsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the field to which the top classes are written.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor TopClassesResultsField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TopClassesResultsField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}