// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class InferenceConfigClassificationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification>
{
	private static readonly System.Text.Json.JsonEncodedText PropNumTopClasses = System.Text.Json.JsonEncodedText.Encode("num_top_classes");
	private static readonly System.Text.Json.JsonEncodedText PropNumTopFeatureImportanceValues = System.Text.Json.JsonEncodedText.Encode("num_top_feature_importance_values");
	private static readonly System.Text.Json.JsonEncodedText PropPredictionFieldType = System.Text.Json.JsonEncodedText.Encode("prediction_field_type");
	private static readonly System.Text.Json.JsonEncodedText PropResultsField = System.Text.Json.JsonEncodedText.Encode("results_field");
	private static readonly System.Text.Json.JsonEncodedText PropTopClassesResultsField = System.Text.Json.JsonEncodedText.Encode("top_classes_results_field");

	public override Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int?> propNumTopClasses = default;
		LocalJsonValue<int?> propNumTopFeatureImportanceValues = default;
		LocalJsonValue<string?> propPredictionFieldType = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propResultsField = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propTopClassesResultsField = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propNumTopClasses.TryReadProperty(ref reader, options, PropNumTopClasses, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNumTopFeatureImportanceValues.TryReadProperty(ref reader, options, PropNumTopFeatureImportanceValues, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propPredictionFieldType.TryReadProperty(ref reader, options, PropPredictionFieldType, null))
			{
				continue;
			}

			if (propResultsField.TryReadProperty(ref reader, options, PropResultsField, null))
			{
				continue;
			}

			if (propTopClassesResultsField.TryReadProperty(ref reader, options, PropTopClassesResultsField, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			NumTopClasses = propNumTopClasses.Value,
			NumTopFeatureImportanceValues = propNumTopFeatureImportanceValues.Value,
			PredictionFieldType = propPredictionFieldType.Value,
			ResultsField = propResultsField.Value,
			TopClassesResultsField = propTopClassesResultsField.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropNumTopClasses, value.NumTopClasses, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNumTopFeatureImportanceValues, value.NumTopFeatureImportanceValues, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropPredictionFieldType, value.PredictionFieldType, null, null);
		writer.WriteProperty(options, PropResultsField, value.ResultsField, null, null);
		writer.WriteProperty(options, PropTopClassesResultsField, value.TopClassesResultsField, null, null);
		writer.WriteEndObject();
	}
}