// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.InferenceConfigConverter))]
public sealed partial class InferenceConfig
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public InferenceConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InferenceConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification? Classification { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification>("classification"); set => SetVariant("classification", value); }

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression? Regression { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression>("regression"); set => SetVariant("regression", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification value) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig { Classification = value };
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression value) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig { Regression = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct InferenceConfigDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Classification(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Classification()
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Classification(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>>? action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Regression(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Regression()
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument> Regression(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfig Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct InferenceConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.InferenceConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor(Elastic.Clients.Elasticsearch.Ingest.InferenceConfig instance) => new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Classification(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassification? value)
	{
		Instance.Classification = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Classification()
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Classification(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor>? action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Classification configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Classification<T>(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<T>>? action)
	{
		Instance.Classification = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigClassificationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Regression(Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegression? value)
	{
		Instance.Regression = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Regression()
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Regression(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Regression configuration for inference.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor Regression<T>(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<T>>? action)
	{
		Instance.Regression = Elastic.Clients.Elasticsearch.Ingest.InferenceConfigRegressionDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.InferenceConfig Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.InferenceConfigDescriptor(new Elastic.Clients.Elasticsearch.Ingest.InferenceConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}