// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.GeoIpDownloadStatisticsConverter))]
public sealed partial class GeoIpDownloadStatistics
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoIpDownloadStatistics(int databasesCount, int expiredDatabases, int failedDownloads, int skippedUpdates, int successfulDownloads, System.TimeSpan totalDownloadTime)
	{
		DatabasesCount = databasesCount;
		ExpiredDatabases = expiredDatabases;
		FailedDownloads = failedDownloads;
		SkippedUpdates = skippedUpdates;
		SuccessfulDownloads = successfulDownloads;
		TotalDownloadTime = totalDownloadTime;
	}
#if NET7_0_OR_GREATER
	public GeoIpDownloadStatistics()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoIpDownloadStatistics()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoIpDownloadStatistics(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Current number of databases available for use.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DatabasesCount { get; set; }

	/// <summary>
	/// <para>
	/// Total number of databases not updated after 30 days
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ExpiredDatabases { get; set; }

	/// <summary>
	/// <para>
	/// Total number of failed database downloads.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int FailedDownloads { get; set; }

	/// <summary>
	/// <para>
	/// Total number of database updates skipped.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int SkippedUpdates { get; set; }

	/// <summary>
	/// <para>
	/// Total number of successful database downloads.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int SuccessfulDownloads { get; set; }

	/// <summary>
	/// <para>
	/// Total milliseconds spent downloading databases.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalDownloadTime { get; set; }
}