// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class GeoGridTileTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGeohash = System.Text.Json.JsonEncodedText.Encode("geohash");
	private static readonly System.Text.Json.JsonEncodedText MemberGeohex = System.Text.Json.JsonEncodedText.Encode("geohex");
	private static readonly System.Text.Json.JsonEncodedText MemberGeotile = System.Text.Json.JsonEncodedText.Encode("geotile");

	public override Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGeohash))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohash;
		}

		if (reader.ValueTextEquals(MemberGeohex))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohex;
		}

		if (reader.ValueTextEquals(MemberGeotile))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geotile;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGeohash.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohash;
		}

		if (string.Equals(value, MemberGeohex.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohex;
		}

		if (string.Equals(value, MemberGeotile.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geotile;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohash:
				writer.WriteStringValue(MemberGeohash);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geohex:
				writer.WriteStringValue(MemberGeohex);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType.Geotile:
				writer.WriteStringValue(MemberGeotile);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}