// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class GeoGridTargetFormatConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGeojson = System.Text.Json.JsonEncodedText.Encode("geojson");
	private static readonly System.Text.Json.JsonEncodedText MemberWkt = System.Text.Json.JsonEncodedText.Encode("wkt");

	public override Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGeojson))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Geojson;
		}

		if (reader.ValueTextEquals(MemberWkt))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Wkt;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGeojson.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Geojson;
		}

		if (string.Equals(value, MemberWkt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Wkt;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Geojson:
				writer.WriteStringValue(MemberGeojson);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat.Wkt:
				writer.WriteStringValue(MemberWkt);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}