// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.GeoGridProcessorConverter))]
public sealed partial class GeoGridProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoGridProcessor(string field, Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType tileType)
	{
		Field = field;
		TileType = tileType;
	}
#if NET7_0_OR_GREATER
	public GeoGridProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoGridProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoGridProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If specified and children tiles exist, save those tile addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? ChildrenField { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to interpret as a geo-tile.=
	/// The field format is determined by the <c>tile_type</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? NonChildrenField { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// If specified and a parent tile exists, save that tile address to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? ParentField { get; set; }

	/// <summary>
	/// <para>
	/// If specified, save the tile precision (zoom) as an integer to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? PrecisionField { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The field to assign the polygon shape to, by default, the <c>field</c> is updated in-place.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }

	/// <summary>
	/// <para>
	/// Which format to save the generated polygon in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat? TargetFormat { get; set; }

	/// <summary>
	/// <para>
	/// Three tile formats are understood: geohash, geotile and geohex.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType TileType { get; set; }
}

public readonly partial struct GeoGridProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoGridProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoGridProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If specified and children tiles exist, save those tile addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> ChildrenField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and children tiles exist, save those tile addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> ChildrenField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to interpret as a geo-tile.=
	/// The field format is determined by the <c>tile_type</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> NonChildrenField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.NonChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> NonChildrenField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.NonChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and a parent tile exists, save that tile address to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> ParentField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ParentField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and a parent tile exists, save that tile address to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> ParentField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.ParentField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, save the tile precision (zoom) as an integer to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> PrecisionField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PrecisionField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, save the tile precision (zoom) as an integer to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> PrecisionField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.PrecisionField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to assign the polygon shape to, by default, the <c>field</c> is updated in-place.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to assign the polygon shape to, by default, the <c>field</c> is updated in-place.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Which format to save the generated polygon in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> TargetFormat(Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat? value)
	{
		Instance.TargetFormat = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Three tile formats are understood: geohash, geotile and geohex.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument> TileType(Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType value)
	{
		Instance.TileType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoGridProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoGridProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoGridProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If specified and children tiles exist, save those tile addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor ChildrenField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and children tiles exist, save those tile addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor ChildrenField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to interpret as a geo-tile.=
	/// The field format is determined by the <c>tile_type</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor Field(string value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and <c>field</c> does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor NonChildrenField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.NonChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor NonChildrenField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.NonChildrenField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and a parent tile exists, save that tile address to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor ParentField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.ParentField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified and a parent tile exists, save that tile address to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor ParentField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.ParentField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, save the tile precision (zoom) as an integer to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor PrecisionField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.PrecisionField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If specified, save the tile precision (zoom) as an integer to this field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor PrecisionField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.PrecisionField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to assign the polygon shape to, by default, the <c>field</c> is updated in-place.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to assign the polygon shape to, by default, the <c>field</c> is updated in-place.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Which format to save the generated polygon in.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor TargetFormat(Elastic.Clients.Elasticsearch.Ingest.GeoGridTargetFormat? value)
	{
		Instance.TargetFormat = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Three tile formats are understood: geohash, geotile and geohex.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor TileType(Elastic.Clients.Elasticsearch.Ingest.GeoGridTileType value)
	{
		Instance.TileType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.GeoGridProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}