// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class FingerprintDigestConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest>
{
	private static readonly System.Text.Json.JsonEncodedText MemberMd5 = System.Text.Json.JsonEncodedText.Encode("MD5");
	private static readonly System.Text.Json.JsonEncodedText MemberMurmurHash3 = System.Text.Json.JsonEncodedText.Encode("MurmurHash3");
	private static readonly System.Text.Json.JsonEncodedText MemberSha1 = System.Text.Json.JsonEncodedText.Encode("SHA-1");
	private static readonly System.Text.Json.JsonEncodedText MemberSha256 = System.Text.Json.JsonEncodedText.Encode("SHA-256");
	private static readonly System.Text.Json.JsonEncodedText MemberSha512 = System.Text.Json.JsonEncodedText.Encode("SHA-512");

	public override Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberMd5))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Md5;
		}

		if (reader.ValueTextEquals(MemberMurmurHash3))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.MurmurHash3;
		}

		if (reader.ValueTextEquals(MemberSha1))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha1;
		}

		if (reader.ValueTextEquals(MemberSha256))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha256;
		}

		if (reader.ValueTextEquals(MemberSha512))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha512;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberMd5.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Md5;
		}

		if (string.Equals(value, MemberMurmurHash3.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.MurmurHash3;
		}

		if (string.Equals(value, MemberSha1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha1;
		}

		if (string.Equals(value, MemberSha256.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha256;
		}

		if (string.Equals(value, MemberSha512.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha512;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Md5:
				writer.WriteStringValue(MemberMd5);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.MurmurHash3:
				writer.WriteStringValue(MemberMurmurHash3);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha1:
				writer.WriteStringValue(MemberSha1);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha256:
				writer.WriteStringValue(MemberSha256);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest.Sha512:
				writer.WriteStringValue(MemberSha512);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.FingerprintDigest value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}