// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

/// <summary>
/// <para>
/// The simulated document, with optional metadata.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.DocumentSimulationConverter))]
public sealed partial class DocumentSimulation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentSimulation(string id, string index, Elastic.Clients.Elasticsearch.Ingest.Ingest ingest, System.Collections.Generic.IReadOnlyDictionary<string, object> source)
	{
		Id = id;
		Index = index;
		Ingest = ingest;
		Source = source;
	}
#if NET7_0_OR_GREATER
	public DocumentSimulation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DocumentSimulation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DocumentSimulation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Unique identifier for the document. This ID must be unique within the <c>_index</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index containing the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Ingest.Ingest Ingest { get; set; }

	/// <summary>
	/// <para>
	/// Additional metadata
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, string>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// Value used to send the document to a specific primary shard.
	/// </para>
	/// </summary>
	public string? Routing { get; set; }

	/// <summary>
	/// <para>
	/// JSON body for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, object> Source { get; set; }
	public long? Version { get; set; }
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get; set; }
}