// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.DocumentConverter))]
public sealed partial class Document
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Document(object source)
	{
		Source = source;
	}
#if NET7_0_OR_GREATER
	public Document()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Document()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Document(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Unique identifier for the document.
	/// This ID must be unique within the <c>_index</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index containing the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// JSON body for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Source { get; set; }
}

public readonly partial struct DocumentDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.Document Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentDescriptor(Elastic.Clients.Elasticsearch.Ingest.Document instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocumentDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.Document(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor(Elastic.Clients.Elasticsearch.Ingest.Document instance) => new Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.Document(Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Unique identifier for the document.
	/// This ID must be unique within the <c>_index</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index containing the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// JSON body for the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor Source(object value)
	{
		Instance.Source = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.Document Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor(new Elastic.Clients.Elasticsearch.Ingest.Document(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}