// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.DateIndexNameProcessorConverter))]
public sealed partial class DateIndexNameProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateIndexNameProcessor(string dateRounding, Elastic.Clients.Elasticsearch.Field field)
	{
		DateRounding = dateRounding;
		Field = field;
	}
#if NET7_0_OR_GREATER
	public DateIndexNameProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DateIndexNameProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// An array of the expected date formats for parsing dates / timestamps in the document being preprocessed.
	/// Can be a java time pattern or one of the following formats: ISO8601, UNIX, UNIX_MS, or TAI64N.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? DateFormats { get; set; }

	/// <summary>
	/// <para>
	/// How to round the date when formatting the date into the index name. Valid values are:
	/// <c>y</c> (year), <c>M</c> (month), <c>w</c> (week), <c>d</c> (day), <c>h</c> (hour), <c>m</c> (minute) and <c>s</c> (second).
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DateRounding { get; set; }

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to get the date or timestamp from.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// The format to be used when printing the parsed date into the index name.
	/// A valid java time pattern is expected here.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public string? IndexNameFormat { get; set; }

	/// <summary>
	/// <para>
	/// A prefix of the index name to be prepended before the printed date.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public string? IndexNamePrefix { get; set; }

	/// <summary>
	/// <para>
	/// The locale to use when parsing the date from the document being preprocessed, relevant when parsing month names or week days.
	/// </para>
	/// </summary>
	public string? Locale { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The timezone to use when parsing the date and when date math index supports resolves expressions into concrete index names.
	/// </para>
	/// </summary>
	public string? Timezone { get; set; }
}

public readonly partial struct DateIndexNameProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateIndexNameProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateIndexNameProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An array of the expected date formats for parsing dates / timestamps in the document being preprocessed.
	/// Can be a java time pattern or one of the following formats: ISO8601, UNIX, UNIX_MS, or TAI64N.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> DateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DateFormats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of the expected date formats for parsing dates / timestamps in the document being preprocessed.
	/// Can be a java time pattern or one of the following formats: ISO8601, UNIX, UNIX_MS, or TAI64N.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> DateFormats(params string[] values)
	{
		Instance.DateFormats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// How to round the date when formatting the date into the index name. Valid values are:
	/// <c>y</c> (year), <c>M</c> (month), <c>w</c> (week), <c>d</c> (day), <c>h</c> (hour), <c>m</c> (minute) and <c>s</c> (second).
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> DateRounding(string value)
	{
		Instance.DateRounding = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the date or timestamp from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the date or timestamp from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The format to be used when printing the parsed date into the index name.
	/// A valid java time pattern is expected here.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> IndexNameFormat(string? value)
	{
		Instance.IndexNameFormat = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A prefix of the index name to be prepended before the printed date.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> IndexNamePrefix(string? value)
	{
		Instance.IndexNamePrefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The locale to use when parsing the date from the document being preprocessed, relevant when parsing month names or week days.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timezone to use when parsing the date and when date math index supports resolves expressions into concrete index names.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument> Timezone(string? value)
	{
		Instance.Timezone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateIndexNameProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateIndexNameProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateIndexNameProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An array of the expected date formats for parsing dates / timestamps in the document being preprocessed.
	/// Can be a java time pattern or one of the following formats: ISO8601, UNIX, UNIX_MS, or TAI64N.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor DateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DateFormats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of the expected date formats for parsing dates / timestamps in the document being preprocessed.
	/// Can be a java time pattern or one of the following formats: ISO8601, UNIX, UNIX_MS, or TAI64N.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor DateFormats(params string[] values)
	{
		Instance.DateFormats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// How to round the date when formatting the date into the index name. Valid values are:
	/// <c>y</c> (year), <c>M</c> (month), <c>w</c> (week), <c>d</c> (day), <c>h</c> (hour), <c>m</c> (minute) and <c>s</c> (second).
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor DateRounding(string value)
	{
		Instance.DateRounding = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the date or timestamp from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the date or timestamp from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The format to be used when printing the parsed date into the index name.
	/// A valid java time pattern is expected here.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor IndexNameFormat(string? value)
	{
		Instance.IndexNameFormat = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A prefix of the index name to be prepended before the printed date.
	/// Supports template snippets.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor IndexNamePrefix(string? value)
	{
		Instance.IndexNamePrefix = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The locale to use when parsing the date from the document being preprocessed, relevant when parsing month names or week days.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timezone to use when parsing the date and when date math index supports resolves expressions into concrete index names.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor Timezone(string? value)
	{
		Instance.Timezone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.DateIndexNameProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}