// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.DatabaseConfigurationFullConverter))]
public sealed partial class DatabaseConfigurationFull
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DatabaseConfigurationFull(string name)
	{
		Name = name;
	}
#if NET7_0_OR_GREATER
	public DatabaseConfigurationFull()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DatabaseConfigurationFull()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DatabaseConfigurationFull(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Ingest.Ipinfo? Ipinfo { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.Ipinfo>("ipinfo"); set => SetVariant("ipinfo", value); }
	public Elastic.Clients.Elasticsearch.Ingest.Local? Local { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.Local>("local"); set => SetVariant("local", value); }
	public Elastic.Clients.Elasticsearch.Ingest.Maxmind? Maxmind { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.Maxmind>("maxmind"); set => SetVariant("maxmind", value); }
	public Elastic.Clients.Elasticsearch.Ingest.Web? Web { get => GetVariant<Elastic.Clients.Elasticsearch.Ingest.Web>("web"); set => SetVariant("web", value); }

	/// <summary>
	/// <para>
	/// The provider-assigned name of the IP geolocation database to download.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}