// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class ConvertTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.ConvertType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAuto = System.Text.Json.JsonEncodedText.Encode("auto");
	private static readonly System.Text.Json.JsonEncodedText MemberBoolean = System.Text.Json.JsonEncodedText.Encode("boolean");
	private static readonly System.Text.Json.JsonEncodedText MemberDouble = System.Text.Json.JsonEncodedText.Encode("double");
	private static readonly System.Text.Json.JsonEncodedText MemberFloat = System.Text.Json.JsonEncodedText.Encode("float");
	private static readonly System.Text.Json.JsonEncodedText MemberInteger = System.Text.Json.JsonEncodedText.Encode("integer");
	private static readonly System.Text.Json.JsonEncodedText MemberIp = System.Text.Json.JsonEncodedText.Encode("ip");
	private static readonly System.Text.Json.JsonEncodedText MemberLong = System.Text.Json.JsonEncodedText.Encode("long");
	private static readonly System.Text.Json.JsonEncodedText MemberString = System.Text.Json.JsonEncodedText.Encode("string");

	public override Elastic.Clients.Elasticsearch.Ingest.ConvertType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAuto))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Auto;
		}

		if (reader.ValueTextEquals(MemberBoolean))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Boolean;
		}

		if (reader.ValueTextEquals(MemberDouble))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Double;
		}

		if (reader.ValueTextEquals(MemberFloat))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Float;
		}

		if (reader.ValueTextEquals(MemberInteger))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Integer;
		}

		if (reader.ValueTextEquals(MemberIp))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Ip;
		}

		if (reader.ValueTextEquals(MemberLong))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Long;
		}

		if (reader.ValueTextEquals(MemberString))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.String;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAuto.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Auto;
		}

		if (string.Equals(value, MemberBoolean.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Boolean;
		}

		if (string.Equals(value, MemberDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Double;
		}

		if (string.Equals(value, MemberFloat.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Float;
		}

		if (string.Equals(value, MemberInteger.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Integer;
		}

		if (string.Equals(value, MemberIp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Ip;
		}

		if (string.Equals(value, MemberLong.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.Long;
		}

		if (string.Equals(value, MemberString.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Ingest.ConvertType.String;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.ConvertType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.ConvertType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Auto:
				writer.WriteStringValue(MemberAuto);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Boolean:
				writer.WriteStringValue(MemberBoolean);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Double:
				writer.WriteStringValue(MemberDouble);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Float:
				writer.WriteStringValue(MemberFloat);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Integer:
				writer.WriteStringValue(MemberInteger);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Ip:
				writer.WriteStringValue(MemberIp);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.Long:
				writer.WriteStringValue(MemberLong);
				break;
			case Elastic.Clients.Elasticsearch.Ingest.ConvertType.String:
				writer.WriteStringValue(MemberString);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Ingest.ConvertType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Ingest.ConvertType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.ConvertType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}