// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest.Json;

public sealed partial class CommunityIDProcessorConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor>
{
	private static readonly System.Text.Json.JsonEncodedText PropDescription = System.Text.Json.JsonEncodedText.Encode("description");
	private static readonly System.Text.Json.JsonEncodedText PropDestinationIp = System.Text.Json.JsonEncodedText.Encode("destination_ip");
	private static readonly System.Text.Json.JsonEncodedText PropDestinationPort = System.Text.Json.JsonEncodedText.Encode("destination_port");
	private static readonly System.Text.Json.JsonEncodedText PropIanaNumber = System.Text.Json.JsonEncodedText.Encode("iana_number");
	private static readonly System.Text.Json.JsonEncodedText PropIcmpCode = System.Text.Json.JsonEncodedText.Encode("icmp_code");
	private static readonly System.Text.Json.JsonEncodedText PropIcmpType = System.Text.Json.JsonEncodedText.Encode("icmp_type");
	private static readonly System.Text.Json.JsonEncodedText PropIf = System.Text.Json.JsonEncodedText.Encode("if");
	private static readonly System.Text.Json.JsonEncodedText PropIgnoreFailure = System.Text.Json.JsonEncodedText.Encode("ignore_failure");
	private static readonly System.Text.Json.JsonEncodedText PropIgnoreMissing = System.Text.Json.JsonEncodedText.Encode("ignore_missing");
	private static readonly System.Text.Json.JsonEncodedText PropOnFailure = System.Text.Json.JsonEncodedText.Encode("on_failure");
	private static readonly System.Text.Json.JsonEncodedText PropSeed = System.Text.Json.JsonEncodedText.Encode("seed");
	private static readonly System.Text.Json.JsonEncodedText PropSourceIp = System.Text.Json.JsonEncodedText.Encode("source_ip");
	private static readonly System.Text.Json.JsonEncodedText PropSourcePort = System.Text.Json.JsonEncodedText.Encode("source_port");
	private static readonly System.Text.Json.JsonEncodedText PropTag = System.Text.Json.JsonEncodedText.Encode("tag");
	private static readonly System.Text.Json.JsonEncodedText PropTargetField = System.Text.Json.JsonEncodedText.Encode("target_field");
	private static readonly System.Text.Json.JsonEncodedText PropTransport = System.Text.Json.JsonEncodedText.Encode("transport");

	public override Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propDescription = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propDestinationIp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propDestinationPort = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propIanaNumber = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propIcmpCode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propIcmpType = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Script?> propIf = default;
		LocalJsonValue<bool?> propIgnoreFailure = default;
		LocalJsonValue<bool?> propIgnoreMissing = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>?> propOnFailure = default;
		LocalJsonValue<int?> propSeed = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propSourceIp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propSourcePort = default;
		LocalJsonValue<string?> propTag = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propTargetField = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Field?> propTransport = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDescription.TryReadProperty(ref reader, options, PropDescription, null))
			{
				continue;
			}

			if (propDestinationIp.TryReadProperty(ref reader, options, PropDestinationIp, null))
			{
				continue;
			}

			if (propDestinationPort.TryReadProperty(ref reader, options, PropDestinationPort, null))
			{
				continue;
			}

			if (propIanaNumber.TryReadProperty(ref reader, options, PropIanaNumber, null))
			{
				continue;
			}

			if (propIcmpCode.TryReadProperty(ref reader, options, PropIcmpCode, null))
			{
				continue;
			}

			if (propIcmpType.TryReadProperty(ref reader, options, PropIcmpType, null))
			{
				continue;
			}

			if (propIf.TryReadProperty(ref reader, options, PropIf, null))
			{
				continue;
			}

			if (propIgnoreFailure.TryReadProperty(ref reader, options, PropIgnoreFailure, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propIgnoreMissing.TryReadProperty(ref reader, options, PropIgnoreMissing, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propOnFailure.TryReadProperty(ref reader, options, PropOnFailure, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Ingest.Processor>(o, null)))
			{
				continue;
			}

			if (propSeed.TryReadProperty(ref reader, options, PropSeed, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propSourceIp.TryReadProperty(ref reader, options, PropSourceIp, null))
			{
				continue;
			}

			if (propSourcePort.TryReadProperty(ref reader, options, PropSourcePort, null))
			{
				continue;
			}

			if (propTag.TryReadProperty(ref reader, options, PropTag, null))
			{
				continue;
			}

			if (propTargetField.TryReadProperty(ref reader, options, PropTargetField, null))
			{
				continue;
			}

			if (propTransport.TryReadProperty(ref reader, options, PropTransport, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Description = propDescription.Value,
			DestinationIp = propDestinationIp.Value,
			DestinationPort = propDestinationPort.Value,
			IanaNumber = propIanaNumber.Value,
			IcmpCode = propIcmpCode.Value,
			IcmpType = propIcmpType.Value,
			If = propIf.Value,
			IgnoreFailure = propIgnoreFailure.Value,
			IgnoreMissing = propIgnoreMissing.Value,
			OnFailure = propOnFailure.Value,
			Seed = propSeed.Value,
			SourceIp = propSourceIp.Value,
			SourcePort = propSourcePort.Value,
			Tag = propTag.Value,
			TargetField = propTargetField.Value,
			Transport = propTransport.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Ingest.CommunityIDProcessor value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDescription, value.Description, null, null);
		writer.WriteProperty(options, PropDestinationIp, value.DestinationIp, null, null);
		writer.WriteProperty(options, PropDestinationPort, value.DestinationPort, null, null);
		writer.WriteProperty(options, PropIanaNumber, value.IanaNumber, null, null);
		writer.WriteProperty(options, PropIcmpCode, value.IcmpCode, null, null);
		writer.WriteProperty(options, PropIcmpType, value.IcmpType, null, null);
		writer.WriteProperty(options, PropIf, value.If, null, null);
		writer.WriteProperty(options, PropIgnoreFailure, value.IgnoreFailure, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropIgnoreMissing, value.IgnoreMissing, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropOnFailure, value.OnFailure, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Ingest.Processor>(o, v, null));
		writer.WriteProperty(options, PropSeed, value.Seed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropSourceIp, value.SourceIp, null, null);
		writer.WriteProperty(options, PropSourcePort, value.SourcePort, null, null);
		writer.WriteProperty(options, PropTag, value.Tag, null, null);
		writer.WriteProperty(options, PropTargetField, value.TargetField, null, null);
		writer.WriteProperty(options, PropTransport, value.Transport, null, null);
		writer.WriteEndObject();
	}
}