// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.AttachmentProcessorConverter))]
public sealed partial class AttachmentProcessor
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AttachmentProcessor(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public AttachmentProcessor()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AttachmentProcessor()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AttachmentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The field to get the base64 encoded field from.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? If { get; set; }

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public bool? IgnoreFailure { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c> and field does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public bool? IgnoreMissing { get; set; }

	/// <summary>
	/// <para>
	/// The number of chars being used for extraction to prevent huge fields.
	/// Use <c>-1</c> for no limit.
	/// </para>
	/// </summary>
	public long? IndexedChars { get; set; }

	/// <summary>
	/// <para>
	/// Field name from which you can overwrite the number of chars being used for extraction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? IndexedCharsField { get; set; }

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? OnFailure { get; set; }

	/// <summary>
	/// <para>
	/// Array of properties to select to be stored.
	/// Can be <c>content</c>, <c>title</c>, <c>name</c>, <c>author</c>, <c>keywords</c>, <c>date</c>, <c>content_type</c>, <c>content_length</c>, <c>language</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Properties { get; set; }

	/// <summary>
	/// <para>
	/// If true, the binary field will be removed from the document
	/// </para>
	/// </summary>
	public bool? RemoveBinary { get; set; }

	/// <summary>
	/// <para>
	/// Field containing the name of the resource to decode.
	/// If specified, the processor passes this resource name to the underlying Tika library to enable Resource Name Based Detection.
	/// </para>
	/// </summary>
	public string? ResourceName { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public string? Tag { get; set; }

	/// <summary>
	/// <para>
	/// The field that will hold the attachment information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TargetField { get; set; }
}

public readonly partial struct AttachmentProcessorDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AttachmentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AttachmentProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the base64 encoded field from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the base64 encoded field from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and field does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of chars being used for extraction to prevent huge fields.
	/// Use <c>-1</c> for no limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> IndexedChars(long? value)
	{
		Instance.IndexedChars = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field name from which you can overwrite the number of chars being used for extraction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> IndexedCharsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.IndexedCharsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field name from which you can overwrite the number of chars being used for extraction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> IndexedCharsField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.IndexedCharsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<TDocument>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of properties to select to be stored.
	/// Can be <c>content</c>, <c>title</c>, <c>name</c>, <c>author</c>, <c>keywords</c>, <c>date</c>, <c>content_type</c>, <c>content_length</c>, <c>language</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Properties(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of properties to select to be stored.
	/// Can be <c>content</c>, <c>title</c>, <c>name</c>, <c>author</c>, <c>keywords</c>, <c>date</c>, <c>content_type</c>, <c>content_length</c>, <c>language</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Properties(params string[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the binary field will be removed from the document
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> RemoveBinary(bool? value = true)
	{
		Instance.RemoveBinary = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the name of the resource to decode.
	/// If specified, the processor passes this resource name to the underlying Tika library to enable Resource Name Based Detection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> ResourceName(string? value)
	{
		Instance.ResourceName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the attachment information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the attachment information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument> TargetField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct AttachmentProcessorDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AttachmentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AttachmentProcessorDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor instance) => new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Description of the processor.
	/// Useful for describing the purpose of the processor or its configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the base64 encoded field from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to get the base64 encoded field from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor If(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.If = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor If()
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Conditionally execute the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor If(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.If = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor IgnoreFailure(bool? value = true)
	{
		Instance.IgnoreFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and field does not exist, the processor quietly exits without modifying the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor IgnoreMissing(bool? value = true)
	{
		Instance.IgnoreMissing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of chars being used for extraction to prevent huge fields.
	/// Use <c>-1</c> for no limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor IndexedChars(long? value)
	{
		Instance.IndexedChars = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field name from which you can overwrite the number of chars being used for extraction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor IndexedCharsField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.IndexedCharsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field name from which you can overwrite the number of chars being used for extraction.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor IndexedCharsField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.IndexedCharsField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor OnFailure(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Processor>? value)
	{
		Instance.OnFailure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor OnFailure(params Elastic.Clients.Elasticsearch.Ingest.Processor[] values)
	{
		Instance.OnFailure = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor OnFailure(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Handle failures for the processor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor OnFailure<T>(params System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Processor>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.ProcessorDescriptor<T>.Build(action));
		}

		Instance.OnFailure = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of properties to select to be stored.
	/// Can be <c>content</c>, <c>title</c>, <c>name</c>, <c>author</c>, <c>keywords</c>, <c>date</c>, <c>content_type</c>, <c>content_length</c>, <c>language</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Properties(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of properties to select to be stored.
	/// Can be <c>content</c>, <c>title</c>, <c>name</c>, <c>author</c>, <c>keywords</c>, <c>date</c>, <c>content_type</c>, <c>content_length</c>, <c>language</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Properties(params string[] values)
	{
		Instance.Properties = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the binary field will be removed from the document
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor RemoveBinary(bool? value = true)
	{
		Instance.RemoveBinary = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the name of the resource to decode.
	/// If specified, the processor passes this resource name to the underlying Tika library to enable Resource Name Based Detection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor ResourceName(string? value)
	{
		Instance.ResourceName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the processor.
	/// Useful for debugging and metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor Tag(string? value)
	{
		Instance.Tag = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the attachment information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor TargetField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TargetField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field that will hold the attachment information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor TargetField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TargetField = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessorDescriptor(new Elastic.Clients.Elasticsearch.Ingest.AttachmentProcessor(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}