// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class WatsonxTaskTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberChatCompletion = System.Text.Json.JsonEncodedText.Encode("chat_completion");
	private static readonly System.Text.Json.JsonEncodedText MemberCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText MemberTextEmbedding = System.Text.Json.JsonEncodedText.Encode("text_embedding");

	public override Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberChatCompletion))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.ChatCompletion;
		}

		if (reader.ValueTextEquals(MemberCompletion))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.Completion;
		}

		if (reader.ValueTextEquals(MemberTextEmbedding))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.TextEmbedding;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberChatCompletion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.ChatCompletion;
		}

		if (string.Equals(value, MemberCompletion.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.Completion;
		}

		if (string.Equals(value, MemberTextEmbedding.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.TextEmbedding;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.ChatCompletion:
				writer.WriteStringValue(MemberChatCompletion);
				break;
			case Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.Completion:
				writer.WriteStringValue(MemberCompletion);
				break;
			case Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType.TextEmbedding:
				writer.WriteStringValue(MemberTextEmbedding);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.WatsonxTaskType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}