// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.WatsonxServiceSettingsConverter))]
public sealed partial class WatsonxServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WatsonxServiceSettings(string apiKey, string apiVersion, string modelId, string projectId, string url)
	{
		ApiKey = apiKey;
		ApiVersion = apiVersion;
		ModelId = modelId;
		ProjectId = projectId;
		Url = url;
	}
#if NET7_0_OR_GREATER
	public WatsonxServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public WatsonxServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WatsonxServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your Watsonx account.
	/// You can find your Watsonx API keys or you can create a new one on the API keys page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// A version parameter that takes a version date in the format of <c>YYYY-MM-DD</c>.
	/// For the active version data parameters, refer to the Wastonx documentation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiVersion { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the IBM Embedding Models section in the Watsonx documentation for the list of available text embedding models.
	/// Refer to the IBM library - Foundation models in Watsonx.ai.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The identifier of the IBM Cloud project to use for the inference task.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ProjectId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The URL of the inference endpoint that you created on Watsonx.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Url { get; set; }
}

public readonly partial struct WatsonxServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WatsonxServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WatsonxServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings(Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your Watsonx account.
	/// You can find your Watsonx API keys or you can create a new one on the API keys page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A version parameter that takes a version date in the format of <c>YYYY-MM-DD</c>.
	/// For the active version data parameters, refer to the Wastonx documentation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor ApiVersion(string value)
	{
		Instance.ApiVersion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the IBM Embedding Models section in the Watsonx documentation for the list of available text embedding models.
	/// Refer to the IBM library - Foundation models in Watsonx.ai.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The identifier of the IBM Cloud project to use for the inference task.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor ProjectId(string value)
	{
		Instance.ProjectId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from Watsonx.
	/// By default, the <c>watsonxai</c> service sets the number of requests allowed per minute to 120.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL of the inference endpoint that you created on Watsonx.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor Url(string value)
	{
		Instance.Url = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.WatsonxServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}