// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.VoyageAITaskSettingsConverter))]
public sealed partial class VoyageAITaskSettings
{
#if NET7_0_OR_GREATER
	public VoyageAITaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public VoyageAITaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal VoyageAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Type of the input text.
	/// Permitted values: <c>ingest</c> (maps to <c>document</c> in the VoyageAI documentation), <c>search</c> (maps to <c>query</c> in the VoyageAI documentation).
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public string? InputType { get; set; }

	/// <summary>
	/// <para>
	/// Whether to return the source documents in the response.
	/// Only for the <c>rerank</c> task type.
	/// </para>
	/// </summary>
	public bool? ReturnDocuments { get; set; }

	/// <summary>
	/// <para>
	/// The number of most relevant documents to return.
	/// If not specified, the reranking results of all documents will be returned.
	/// Only for the <c>rerank</c> task type.
	/// </para>
	/// </summary>
	public int? TopK { get; set; }

	/// <summary>
	/// <para>
	/// Whether to truncate the input texts to fit within the context length.
	/// </para>
	/// </summary>
	public bool? Truncation { get; set; }
}

public readonly partial struct VoyageAiTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VoyageAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VoyageAiTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings(Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Type of the input text.
	/// Permitted values: <c>ingest</c> (maps to <c>document</c> in the VoyageAI documentation), <c>search</c> (maps to <c>query</c> in the VoyageAI documentation).
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor InputType(string? value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to return the source documents in the response.
	/// Only for the <c>rerank</c> task type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor ReturnDocuments(bool? value = true)
	{
		Instance.ReturnDocuments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of most relevant documents to return.
	/// If not specified, the reranking results of all documents will be returned.
	/// Only for the <c>rerank</c> task type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor TopK(int? value)
	{
		Instance.TopK = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to truncate the input texts to fit within the context length.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor Truncation(bool? value = true)
	{
		Instance.Truncation = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.VoyageAiTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.VoyageAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}