// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.VoyageAIServiceSettingsConverter))]
public sealed partial class VoyageAIServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VoyageAIServiceSettings(string modelId)
	{
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public VoyageAIServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public VoyageAIServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal VoyageAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of dimensions for resulting output embeddings.
	/// This setting maps to <c>output_dimension</c> in the VoyageAI documentation.
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public int? Dimensions { get; set; }

	/// <summary>
	/// <para>
	/// The data type for the embeddings to be returned.
	/// This setting maps to <c>output_dtype</c> in the VoyageAI documentation.
	/// Permitted values: float, int8, bit.
	/// <c>int8</c> is a synonym of <c>byte</c> in the VoyageAI documentation.
	/// <c>bit</c> is a synonym of <c>binary</c> in the VoyageAI documentation.
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public float? EmbeddingType { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the VoyageAI documentation for the list of available text embedding and rerank models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from VoyageAI.
	/// The <c>voyageai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For both <c>text_embedding</c> and <c>rerank</c>, it is set to <c>2000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }
}

public readonly partial struct VoyageAiServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VoyageAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VoyageAiServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings(Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The number of dimensions for resulting output embeddings.
	/// This setting maps to <c>output_dimension</c> in the VoyageAI documentation.
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor Dimensions(int? value)
	{
		Instance.Dimensions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The data type for the embeddings to be returned.
	/// This setting maps to <c>output_dtype</c> in the VoyageAI documentation.
	/// Permitted values: float, int8, bit.
	/// <c>int8</c> is a synonym of <c>byte</c> in the VoyageAI documentation.
	/// <c>bit</c> is a synonym of <c>binary</c> in the VoyageAI documentation.
	/// Only for the <c>text_embedding</c> task type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor EmbeddingType(float? value)
	{
		Instance.EmbeddingType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the VoyageAI documentation for the list of available text embedding and rerank models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from VoyageAI.
	/// The <c>voyageai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For both <c>text_embedding</c> and <c>rerank</c>, it is set to <c>2000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from VoyageAI.
	/// The <c>voyageai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For both <c>text_embedding</c> and <c>rerank</c>, it is set to <c>2000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from VoyageAI.
	/// The <c>voyageai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For both <c>text_embedding</c> and <c>rerank</c>, it is set to <c>2000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.VoyageAiServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.VoyageAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}