// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// The function that the model called.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.ToolCallFunctionConverter))]
public sealed partial class ToolCallFunction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCallFunction(string arguments, string name)
	{
		Arguments = arguments;
		Name = name;
	}
#if NET7_0_OR_GREATER
	public ToolCallFunction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ToolCallFunction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ToolCallFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The arguments to call the function with in JSON format.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Arguments { get; set; }

	/// <summary>
	/// <para>
	/// The name of the function to call.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }
}

/// <summary>
/// <para>
/// The function that the model called.
/// </para>
/// </summary>
public readonly partial struct ToolCallFunctionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.ToolCallFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCallFunctionDescriptor(Elastic.Clients.Elasticsearch.Inference.ToolCallFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCallFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.ToolCallFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor(Elastic.Clients.Elasticsearch.Inference.ToolCallFunction instance) => new Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.ToolCallFunction(Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The arguments to call the function with in JSON format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor Arguments(string value)
	{
		Instance.Arguments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the function to call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor Name(string value)
	{
		Instance.Name = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.ToolCallFunction Build(System.Action<Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor(new Elastic.Clients.Elasticsearch.Inference.ToolCallFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}