// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// A tool call generated by the model.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.ToolCallConverter))]
public sealed partial class ToolCall
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCall(Elastic.Clients.Elasticsearch.Inference.ToolCallFunction function, Elastic.Clients.Elasticsearch.Id id, string type)
	{
		Function = function;
		Id = id;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public ToolCall()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ToolCall()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ToolCall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The function that the model called.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.ToolCallFunction Function { get; set; }

	/// <summary>
	/// <para>
	/// The identifier of the tool call.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get; set; }

	/// <summary>
	/// <para>
	/// The type of the tool call.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Type { get; set; }
}

/// <summary>
/// <para>
/// A tool call generated by the model.
/// </para>
/// </summary>
public readonly partial struct ToolCallDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.ToolCall Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCallDescriptor(Elastic.Clients.Elasticsearch.Inference.ToolCall instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ToolCallDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.ToolCall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor(Elastic.Clients.Elasticsearch.Inference.ToolCall instance) => new Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.ToolCall(Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The function that the model called.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor Function(Elastic.Clients.Elasticsearch.Inference.ToolCallFunction value)
	{
		Instance.Function = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The function that the model called.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor Function(System.Action<Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor> action)
	{
		Instance.Function = Elastic.Clients.Elasticsearch.Inference.ToolCallFunctionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The identifier of the tool call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of the tool call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor Type(string value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.ToolCall Build(System.Action<Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor(new Elastic.Clients.Elasticsearch.Inference.ToolCall(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}