// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.RequestChatCompletionConverter))]
public sealed partial class RequestChatCompletion
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RequestChatCompletion(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message> messages)
	{
		Messages = messages;
	}
#if NET7_0_OR_GREATER
	public RequestChatCompletion()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RequestChatCompletion()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RequestChatCompletion(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The upper bound limit for the number of tokens that can be generated for a completion request.
	/// </para>
	/// </summary>
	public long? MaxCompletionTokens { get; set; }

	/// <summary>
	/// <para>
	/// A list of objects representing the conversation.
	/// Requests should generally only add new messages from the user (role <c>user</c>).
	/// The other message roles (<c>assistant</c>, <c>system</c>, or <c>tool</c>) should generally only be copied from the response to a previous completion request, such that the messages array is built up throughout a conversation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message> Messages { get; set; }

	/// <summary>
	/// <para>
	/// The ID of the model to use.
	/// </para>
	/// </summary>
	public string? Model { get; set; }

	/// <summary>
	/// <para>
	/// A sequence of strings to control when the model should stop generating additional tokens.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Stop { get; set; }

	/// <summary>
	/// <para>
	/// The sampling temperature to use.
	/// </para>
	/// </summary>
	public float? Temperature { get; set; }

	/// <summary>
	/// <para>
	/// Controls which tool is called by the model.
	/// String representation: One of <c>auto</c>, <c>none</c>, or <c>requrired</c>. <c>auto</c> allows the model to choose between calling tools and generating a message. <c>none</c> causes the model to not call any tools. <c>required</c> forces the model to call one or more tools.
	/// Example (object representation):
	/// </para>
	/// <code>
	/// {
	///   "tool_choice": {
	///       "type": "function",
	///       "function": {
	///           "name": "get_current_weather"
	///       }
	///   }
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>? ToolChoice { get; set; }

	/// <summary>
	/// <para>
	/// A list of tools that the model can call.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tools": [
	///       {
	///           "type": "function",
	///           "function": {
	///               "name": "get_price_of_item",
	///               "description": "Get the current price of an item",
	///               "parameters": {
	///                   "type": "object",
	///                   "properties": {
	///                       "item": {
	///                           "id": "12345"
	///                       },
	///                       "unit": {
	///                           "type": "currency"
	///                       }
	///                   }
	///               }
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.CompletionTool>? Tools { get; set; }

	/// <summary>
	/// <para>
	/// Nucleus sampling, an alternative to sampling with temperature.
	/// </para>
	/// </summary>
	public float? TopP { get; set; }
}

public readonly partial struct RequestChatCompletionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RequestChatCompletionDescriptor(Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RequestChatCompletionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor(Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion instance) => new Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion(Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The upper bound limit for the number of tokens that can be generated for a completion request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor MaxCompletionTokens(long? value)
	{
		Instance.MaxCompletionTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of objects representing the conversation.
	/// Requests should generally only add new messages from the user (role <c>user</c>).
	/// The other message roles (<c>assistant</c>, <c>system</c>, or <c>tool</c>) should generally only be copied from the response to a previous completion request, such that the messages array is built up throughout a conversation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Messages(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message> value)
	{
		Instance.Messages = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of objects representing the conversation.
	/// Requests should generally only add new messages from the user (role <c>user</c>).
	/// The other message roles (<c>assistant</c>, <c>system</c>, or <c>tool</c>) should generally only be copied from the response to a previous completion request, such that the messages array is built up throughout a conversation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Messages(params Elastic.Clients.Elasticsearch.Inference.Message[] values)
	{
		Instance.Messages = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of objects representing the conversation.
	/// Requests should generally only add new messages from the user (role <c>user</c>).
	/// The other message roles (<c>assistant</c>, <c>system</c>, or <c>tool</c>) should generally only be copied from the response to a previous completion request, such that the messages array is built up throughout a conversation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Messages(params System.Action<Elastic.Clients.Elasticsearch.Inference.MessageDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Inference.Message>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Inference.MessageDescriptor.Build(action));
		}

		Instance.Messages = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID of the model to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Model(string? value)
	{
		Instance.Model = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A sequence of strings to control when the model should stop generating additional tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Stop(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stop = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A sequence of strings to control when the model should stop generating additional tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Stop(params string[] values)
	{
		Instance.Stop = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The sampling temperature to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Temperature(float? value)
	{
		Instance.Temperature = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls which tool is called by the model.
	/// String representation: One of <c>auto</c>, <c>none</c>, or <c>requrired</c>. <c>auto</c> allows the model to choose between calling tools and generating a message. <c>none</c> causes the model to not call any tools. <c>required</c> forces the model to call one or more tools.
	/// Example (object representation):
	/// </para>
	/// <code>
	/// {
	///   "tool_choice": {
	///       "type": "function",
	///       "function": {
	///           "name": "get_current_weather"
	///       }
	///   }
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor ToolChoice(Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>? value)
	{
		Instance.ToolChoice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of tools that the model can call.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tools": [
	///       {
	///           "type": "function",
	///           "function": {
	///               "name": "get_price_of_item",
	///               "description": "Get the current price of an item",
	///               "parameters": {
	///                   "type": "object",
	///                   "properties": {
	///                       "item": {
	///                           "id": "12345"
	///                       },
	///                       "unit": {
	///                           "type": "currency"
	///                       }
	///                   }
	///               }
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Tools(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.CompletionTool>? value)
	{
		Instance.Tools = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of tools that the model can call.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tools": [
	///       {
	///           "type": "function",
	///           "function": {
	///               "name": "get_price_of_item",
	///               "description": "Get the current price of an item",
	///               "parameters": {
	///                   "type": "object",
	///                   "properties": {
	///                       "item": {
	///                           "id": "12345"
	///                       },
	///                       "unit": {
	///                           "type": "currency"
	///                       }
	///                   }
	///               }
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Tools(params Elastic.Clients.Elasticsearch.Inference.CompletionTool[] values)
	{
		Instance.Tools = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of tools that the model can call.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tools": [
	///       {
	///           "type": "function",
	///           "function": {
	///               "name": "get_price_of_item",
	///               "description": "Get the current price of an item",
	///               "parameters": {
	///                   "type": "object",
	///                   "properties": {
	///                       "item": {
	///                           "id": "12345"
	///                       },
	///                       "unit": {
	///                           "type": "currency"
	///                       }
	///                   }
	///               }
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor Tools(params System.Action<Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Inference.CompletionTool>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Inference.CompletionToolDescriptor.Build(action));
		}

		Instance.Tools = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Nucleus sampling, an alternative to sampling with temperature.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor TopP(float? value)
	{
		Instance.TopP = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion Build(System.Action<Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor(new Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}