// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference.Json;

public sealed partial class RequestChatCompletionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion>
{
	private static readonly System.Text.Json.JsonEncodedText PropMaxCompletionTokens = System.Text.Json.JsonEncodedText.Encode("max_completion_tokens");
	private static readonly System.Text.Json.JsonEncodedText PropMessages = System.Text.Json.JsonEncodedText.Encode("messages");
	private static readonly System.Text.Json.JsonEncodedText PropModel = System.Text.Json.JsonEncodedText.Encode("model");
	private static readonly System.Text.Json.JsonEncodedText PropStop = System.Text.Json.JsonEncodedText.Encode("stop");
	private static readonly System.Text.Json.JsonEncodedText PropTemperature = System.Text.Json.JsonEncodedText.Encode("temperature");
	private static readonly System.Text.Json.JsonEncodedText PropToolChoice = System.Text.Json.JsonEncodedText.Encode("tool_choice");
	private static readonly System.Text.Json.JsonEncodedText PropTools = System.Text.Json.JsonEncodedText.Encode("tools");
	private static readonly System.Text.Json.JsonEncodedText PropTopP = System.Text.Json.JsonEncodedText.Encode("top_p");

	public override Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long?> propMaxCompletionTokens = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message>> propMessages = default;
		LocalJsonValue<string?> propModel = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propStop = default;
		LocalJsonValue<float?> propTemperature = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>?> propToolChoice = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.CompletionTool>?> propTools = default;
		LocalJsonValue<float?> propTopP = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propMaxCompletionTokens.TryReadProperty(ref reader, options, PropMaxCompletionTokens, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMessages.TryReadProperty(ref reader, options, PropMessages, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.Message>(o, null)!))
			{
				continue;
			}

			if (propModel.TryReadProperty(ref reader, options, PropModel, null))
			{
				continue;
			}

			if (propStop.TryReadProperty(ref reader, options, PropStop, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propTemperature.TryReadProperty(ref reader, options, PropTemperature, static float? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<float>(o)))
			{
				continue;
			}

			if (propToolChoice.TryReadProperty(ref reader, options, PropToolChoice, static Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.StartObject), null, null)))
			{
				continue;
			}

			if (propTools.TryReadProperty(ref reader, options, PropTools, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.CompletionTool>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Inference.CompletionTool>(o, null)))
			{
				continue;
			}

			if (propTopP.TryReadProperty(ref reader, options, PropTopP, static float? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<float>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			MaxCompletionTokens = propMaxCompletionTokens.Value,
			Messages = propMessages.Value,
			Model = propModel.Value,
			Stop = propStop.Value,
			Temperature = propTemperature.Value,
			ToolChoice = propToolChoice.Value,
			Tools = propTools.Value,
			TopP = propTopP.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropMaxCompletionTokens, value.MaxCompletionTokens, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMessages, value.Messages, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.Message> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.Message>(o, v, null));
		writer.WriteProperty(options, PropModel, value.Model, null, null);
		writer.WriteProperty(options, PropStop, value.Stop, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropTemperature, value.Temperature, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, float? v) => w.WriteNullableValue<float>(o, v));
		writer.WriteProperty(options, PropToolChoice, value.ToolChoice, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>? v) => w.WriteUnionValue<string, Elastic.Clients.Elasticsearch.Inference.CompletionToolChoice>(o, v, null, null));
		writer.WriteProperty(options, PropTools, value.Tools, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.CompletionTool>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Inference.CompletionTool>(o, v, null));
		writer.WriteProperty(options, PropTopP, value.TopP, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, float? v) => w.WriteNullableValue<float>(o, v));
		writer.WriteEndObject();
	}
}