// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// This setting helps to minimize the number of rate limit errors returned from the service.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.RateLimitSettingConverter))]
public sealed partial class RateLimitSetting
{
#if NET7_0_OR_GREATER
	public RateLimitSetting()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RateLimitSetting()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RateLimitSetting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of requests allowed per minute.
	/// By default, the number of requests allowed per minute is set by each service as follows:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>alibabacloud-ai-search</c> service: <c>1000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>anthropic</c> service: <c>50</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureaistudio</c> service: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureopenai</c> service and task type <c>text_embedding</c>: <c>1440</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureopenai</c> service and task type <c>completion</c>: <c>120</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>cohere</c> service: <c>10000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>elastic</c> service and task type <c>chat_completion</c>: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>googleaistudio</c> service: <c>360</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>googlevertexai</c> service: <c>30000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>hugging_face</c> service: <c>3000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>jinaai</c> service: <c>2000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> service: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> service and task type <c>text_embedding</c>: <c>3000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> service and task type <c>completion</c>: <c>500</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>voyageai</c> service: <c>2000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>watsonxai</c> service: <c>120</c>
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public int? RequestsPerMinute { get; set; }
}

/// <summary>
/// <para>
/// This setting helps to minimize the number of rate limit errors returned from the service.
/// </para>
/// </summary>
public readonly partial struct RateLimitSettingDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.RateLimitSetting Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RateLimitSettingDescriptor(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RateLimitSettingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.RateLimitSetting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting instance) => new Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.RateLimitSetting(Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The number of requests allowed per minute.
	/// By default, the number of requests allowed per minute is set by each service as follows:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>alibabacloud-ai-search</c> service: <c>1000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>anthropic</c> service: <c>50</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureaistudio</c> service: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureopenai</c> service and task type <c>text_embedding</c>: <c>1440</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>azureopenai</c> service and task type <c>completion</c>: <c>120</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>cohere</c> service: <c>10000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>elastic</c> service and task type <c>chat_completion</c>: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>googleaistudio</c> service: <c>360</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>googlevertexai</c> service: <c>30000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>hugging_face</c> service: <c>3000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>jinaai</c> service: <c>2000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>mistral</c> service: <c>240</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> service and task type <c>text_embedding</c>: <c>3000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>openai</c> service and task type <c>completion</c>: <c>500</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>voyageai</c> service: <c>2000</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>watsonxai</c> service: <c>120</c>
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor RequestsPerMinute(int? value)
	{
		Instance.RequestsPerMinute = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.RateLimitSetting Build(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.RateLimitSetting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor(new Elastic.Clients.Elasticsearch.Inference.RateLimitSetting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}