// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.OpenAITaskSettingsConverter))]
public sealed partial class OpenAITaskSettings
{
#if NET7_0_OR_GREATER
	public OpenAITaskSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public OpenAITaskSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public string? User { get; set; }
}

public readonly partial struct OpenAiTaskSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OpenAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OpenAiTaskSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings instance) => new Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings(Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a <c>completion</c> or <c>text_embedding</c> task, specify the user issuing the request.
	/// This information can be used for abuse detection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor User(string? value)
	{
		Instance.User = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.OpenAiTaskSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.OpenAITaskSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}