// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.OpenAIServiceSettingsConverter))]
public sealed partial class OpenAIServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OpenAIServiceSettings(string apiKey, string modelId)
	{
		ApiKey = apiKey;
		ModelId = modelId;
	}
#if NET7_0_OR_GREATER
	public OpenAIServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public OpenAIServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your OpenAI account.
	/// You can find your OpenAI API keys in your OpenAI account under the API keys section.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The number of dimensions the resulting output embeddings should have.
	/// It is supported only in <c>text-embedding-3</c> and later models.
	/// If it is not set, the OpenAI defined default for the model is used.
	/// </para>
	/// </summary>
	public int? Dimensions { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the OpenAI documentation for the list of available text embedding models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for your organization.
	/// You can find the Organization ID in your OpenAI account under <em>Settings > Organizations</em>.
	/// </para>
	/// </summary>
	public string? OrganizationId { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from OpenAI.
	/// The <c>openai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>3000</c>.
	/// For <c>completion</c>, it is set to <c>500</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests.
	/// It can be changed for testing purposes.
	/// </para>
	/// </summary>
	public string? Url { get; set; }
}

public readonly partial struct OpenAiServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OpenAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OpenAiServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings(Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your OpenAI account.
	/// You can find your OpenAI API keys in your OpenAI account under the API keys section.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of dimensions the resulting output embeddings should have.
	/// It is supported only in <c>text-embedding-3</c> and later models.
	/// If it is not set, the OpenAI defined default for the model is used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor Dimensions(int? value)
	{
		Instance.Dimensions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the OpenAI documentation for the list of available text embedding models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor ModelId(string value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The unique identifier for your organization.
	/// You can find the Organization ID in your OpenAI account under <em>Settings > Organizations</em>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor OrganizationId(string? value)
	{
		Instance.OrganizationId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from OpenAI.
	/// The <c>openai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>3000</c>.
	/// For <c>completion</c>, it is set to <c>500</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from OpenAI.
	/// The <c>openai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>3000</c>.
	/// For <c>completion</c>, it is set to <c>500</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from OpenAI.
	/// The <c>openai</c> service sets a default number of requests allowed per minute depending on the task type.
	/// For <c>text_embedding</c>, it is set to <c>3000</c>.
	/// For <c>completion</c>, it is set to <c>500</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL endpoint to use for the requests.
	/// It can be changed for testing purposes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor Url(string? value)
	{
		Instance.Url = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.OpenAiServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.OpenAIServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}