// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.MistralServiceSettingsConverter))]
public sealed partial class MistralServiceSettings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MistralServiceSettings(string apiKey, string model)
	{
		ApiKey = apiKey;
		Model = model;
	}
#if NET7_0_OR_GREATER
	public MistralServiceSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MistralServiceSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MistralServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A valid API key of your Mistral account.
	/// You can find your Mistral API keys or you can create a new one on the API Keys page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of tokens per input before chunking occurs.
	/// </para>
	/// </summary>
	public int? MaxInputTokens { get; set; }

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Mistral models documentation for the list of available models.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Model { get; set; }

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from the Mistral API.
	/// By default, the <c>mistral</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? RateLimit { get; set; }
}

public readonly partial struct MistralServiceSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MistralServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MistralServiceSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor(Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings instance) => new Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings(Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A valid API key of your Mistral account.
	/// You can find your Mistral API keys or you can create a new one on the API Keys page.
	/// </para>
	/// <para>
	/// IMPORTANT: You need to provide the API key only once, during the inference model creation.
	/// The get inference endpoint API does not retrieve your API key.
	/// After creating the inference model, you cannot change the associated API key.
	/// If you want to use a different API key, delete the inference model and recreate it with the same name and the updated API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor ApiKey(string value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of tokens per input before chunking occurs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor MaxInputTokens(int? value)
	{
		Instance.MaxInputTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the model to use for the inference task.
	/// Refer to the Mistral models documentation for the list of available models.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor Model(string value)
	{
		Instance.Model = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from the Mistral API.
	/// By default, the <c>mistral</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor RateLimit(Elastic.Clients.Elasticsearch.Inference.RateLimitSetting? value)
	{
		Instance.RateLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from the Mistral API.
	/// By default, the <c>mistral</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor RateLimit()
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting helps to minimize the number of rate limit errors returned from the Mistral API.
	/// By default, the <c>mistral</c> service sets the number of requests allowed per minute to 240.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor RateLimit(System.Action<Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor>? action)
	{
		Instance.RateLimit = Elastic.Clients.Elasticsearch.Inference.RateLimitSettingDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings Build(System.Action<Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.MistralServiceSettingsDescriptor(new Elastic.Clients.Elasticsearch.Inference.MistralServiceSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}