// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

/// <summary>
/// <para>
/// An object representing part of the conversation.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.MessageConverter))]
public sealed partial class Message
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public Message(string role)
	{
		Role = role;
	}
#if NET7_0_OR_GREATER
	public Message()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public Message()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Message(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The content of the message.
	/// </para>
	/// <para>
	/// String example:
	/// </para>
	/// <code>
	/// {
	///    "content": "Some string"
	/// }
	/// </code>
	/// <para>
	/// Object example:
	/// </para>
	/// <code>
	/// {
	///   "content": [
	///       {
	///        "text": "Some text",
	///        "type": "text"
	///       }
	///    ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>? Content { get; set; }

	/// <summary>
	/// <para>
	/// The role of the message author. Valid values are <c>user</c>, <c>assistant</c>, <c>system</c>, and <c>tool</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Role { get; set; }

	/// <summary>
	/// <para>
	/// Only for <c>tool</c> role messages. The tool call that this message is responding to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? ToolCallId { get; set; }

	/// <summary>
	/// <para>
	/// Only for <c>assistant</c> role messages. The tool calls generated by the model. If it's specified, the <c>content</c> field is optional.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tool_calls": [
	///       {
	///           "id": "call_KcAjWtAww20AihPHphUh46Gd",
	///           "type": "function",
	///           "function": {
	///               "name": "get_current_weather",
	///               "arguments": "{\"location\":\"Boston, MA\"}"
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ToolCall>? ToolCalls { get; set; }
}

/// <summary>
/// <para>
/// An object representing part of the conversation.
/// </para>
/// </summary>
public readonly partial struct MessageDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.Message Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MessageDescriptor(Elastic.Clients.Elasticsearch.Inference.Message instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MessageDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.Message(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.MessageDescriptor(Elastic.Clients.Elasticsearch.Inference.Message instance) => new Elastic.Clients.Elasticsearch.Inference.MessageDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.Message(Elastic.Clients.Elasticsearch.Inference.MessageDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The content of the message.
	/// </para>
	/// <para>
	/// String example:
	/// </para>
	/// <code>
	/// {
	///    "content": "Some string"
	/// }
	/// </code>
	/// <para>
	/// Object example:
	/// </para>
	/// <code>
	/// {
	///   "content": [
	///       {
	///        "text": "Some text",
	///        "type": "text"
	///       }
	///    ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor Content(Elastic.Clients.Elasticsearch.Union<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ContentObject>>? value)
	{
		Instance.Content = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role of the message author. Valid values are <c>user</c>, <c>assistant</c>, <c>system</c>, and <c>tool</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor Role(string value)
	{
		Instance.Role = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only for <c>tool</c> role messages. The tool call that this message is responding to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor ToolCallId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.ToolCallId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only for <c>assistant</c> role messages. The tool calls generated by the model. If it's specified, the <c>content</c> field is optional.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tool_calls": [
	///       {
	///           "id": "call_KcAjWtAww20AihPHphUh46Gd",
	///           "type": "function",
	///           "function": {
	///               "name": "get_current_weather",
	///               "arguments": "{\"location\":\"Boston, MA\"}"
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor ToolCalls(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Inference.ToolCall>? value)
	{
		Instance.ToolCalls = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only for <c>assistant</c> role messages. The tool calls generated by the model. If it's specified, the <c>content</c> field is optional.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tool_calls": [
	///       {
	///           "id": "call_KcAjWtAww20AihPHphUh46Gd",
	///           "type": "function",
	///           "function": {
	///               "name": "get_current_weather",
	///               "arguments": "{\"location\":\"Boston, MA\"}"
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor ToolCalls(params Elastic.Clients.Elasticsearch.Inference.ToolCall[] values)
	{
		Instance.ToolCalls = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Only for <c>assistant</c> role messages. The tool calls generated by the model. If it's specified, the <c>content</c> field is optional.
	/// Example:
	/// </para>
	/// <code>
	/// {
	///   "tool_calls": [
	///       {
	///           "id": "call_KcAjWtAww20AihPHphUh46Gd",
	///           "type": "function",
	///           "function": {
	///               "name": "get_current_weather",
	///               "arguments": "{\"location\":\"Boston, MA\"}"
	///           }
	///       }
	///   ]
	/// }
	/// </code>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.MessageDescriptor ToolCalls(params System.Action<Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Inference.ToolCall>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Inference.ToolCallDescriptor.Build(action));
		}

		Instance.ToolCalls = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.Message Build(System.Action<Elastic.Clients.Elasticsearch.Inference.MessageDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.MessageDescriptor(new Elastic.Clients.Elasticsearch.Inference.Message(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}